/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXPipe;
import org.newsclub.net.unix.AFUNIXSelectorProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXPipeTest {
    @Test
    public void testPipe() throws IOException {
        this.testPipe0(false);
    }

    @Test
    public void testSelectablePipe() throws IOException {
        this.testPipe0(true);
    }

    private void testPipe0(boolean selectable) throws IOException {
        ByteBuffer out = ByteBuffer.allocate(4);
        out.putInt(67305985);
        out.flip();
        ByteBuffer in = ByteBuffer.allocate(4);
        AFUNIXSelectorProvider provider = AFUNIXSelectorProvider.provider();
        AFUNIXPipe pipe = selectable ? provider.openSelectablePipe() : provider.openPipe();
        try (AFUNIXPipe.SinkChannel sink = pipe.sink();
             AFUNIXPipe.SourceChannel source = pipe.source();){
            int nRead;
            sink.write(out);
            while ((nRead = source.read(in)) == 0) {
            }
            in.flip();
            Assertions.assertEquals((int)67305985, (int)in.getInt());
        }
    }
}

