/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.selftest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.console.options.Theme;
import org.junit.platform.console.tasks.ConsoleTestExecutor;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketCapability;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Selftest {
    private static final Class<? extends Annotation> CAP_ANNOTATION_CLASS = Selftest.getAFUNIXSocketCapabilityRequirementClass();
    private final Map<String, Object> results = new LinkedHashMap<String, Object>();
    private final PrintWriter out;
    private final List<AFUNIXSocketCapability> supportedCapabilites = new ArrayList<AFUNIXSocketCapability>();
    private final List<AFUNIXSocketCapability> unsupportedCapabilites = new ArrayList<AFUNIXSocketCapability>();
    private boolean withIssues = false;
    private boolean fail = false;

    public Selftest(PrintWriter out) {
        this.out = out;
    }

    public static void main(String[] args) throws Exception {
        Selftest st = new Selftest(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()), true));
        st.printExplanation();
        st.dumpSystemProperties();
        st.checkSupported();
        st.checkCapabilities();
        st.runTests("junixsocket-common", new String[]{"org.newsclub.net.unix.AcceptTimeoutTest", "org.newsclub.net.unix.AFUNIXSocketAddressTest", "org.newsclub.net.unix.AvailableTest", "org.newsclub.net.unix.BufferOverflowTest", "org.newsclub.net.unix.CancelAcceptTest", "org.newsclub.net.unix.EndOfFileJavaTest", "org.newsclub.net.unix.EndOfFileTest", "org.newsclub.net.unix.FileDescriptorsTest", "org.newsclub.net.unix.PeerCredentialsTest", "org.newsclub.net.unix.ServerSocketCloseTest", "org.newsclub.net.unix.SoTimeoutTest", "org.newsclub.net.unix.TcpNoDelayTest"});
        st.runTests("junixsocket-rmi", new String[]{"org.newsclub.net.unix.rmi.RemoteFileDescriptorTest"});
        st.dumpResults();
        System.exit(st.isFail() ? 1 : 0);
    }

    public void printExplanation() throws IOException {
        this.out.println("junixsocket selftest");
        this.out.println();
        this.out.println("This program determines whether junixsocket is supported on the current platform.");
        this.out.println("The final line should say whether the selftest passed or failed.");
        this.out.println("If the selftest failed, please visit https://github.com/kohlschutter/junixsocket/issues");
        this.out.println("and file a new bug report with the output below.");
        this.out.println();
        this.out.println("selftest version " + AFUNIXSocket.getVersion());
        this.out.println();
    }

    public void dumpSystemProperties() {
        this.out.println("System properties:");
        this.out.println();
        for (Object key : new TreeSet<Object>(System.getProperties().keySet())) {
            String value = System.getProperty(key.toString());
            StringBuilder sb = new StringBuilder();
            block6: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\n': {
                        sb.append("\\n");
                        continue block6;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block6;
                    }
                    case '\t': {
                        sb.append("\\r");
                        continue block6;
                    }
                    default: {
                        if (c < ' ' || c >= '\u007f') {
                            sb.append(String.format(Locale.ENGLISH, "\\u%04x", (int)c));
                        }
                        sb.append(c);
                    }
                }
            }
            this.out.println(key + ": " + sb.toString());
        }
        this.out.println();
    }

    public void checkSupported() {
        this.out.print("AFUNIXSocket.isSupported: ");
        this.out.flush();
        boolean isSupported = AFUNIXSocket.isSupported();
        this.out.println(isSupported);
        this.out.println();
        this.out.flush();
        if (!isSupported) {
            this.out.println("FAIL: junixsocket is not supported on this platform");
            this.out.println();
            this.fail = true;
        }
    }

    public void checkCapabilities() {
        for (AFUNIXSocketCapability cap : AFUNIXSocketCapability.values()) {
            boolean supported = AFUNIXSocket.supports((AFUNIXSocketCapability)cap);
            (supported ? this.supportedCapabilites : this.unsupportedCapabilites).add(cap);
        }
    }

    public boolean isFail() {
        return this.fail;
    }

    public void dumpResults() {
        this.out.println();
        this.out.println("Selftest results:");
        for (Map.Entry<String, Object> en : this.results.entrySet()) {
            Object res = en.getValue();
            String result = "DONE";
            String extra = "";
            if (res == null) {
                result = "SKIP";
                extra = "(skipped by user request)";
            } else if (res instanceof Throwable) {
                result = "FAIL";
                extra = res.toString();
                this.fail = true;
            } else {
                TestExecutionSummary summary = (TestExecutionSummary)en.getValue();
                extra = summary.getTestsSucceededCount() + "/" + summary.getTestsFoundCount();
                long nSkipped = summary.getTestsSkippedCount();
                if (nSkipped > 0L) {
                    extra = extra + " (" + nSkipped + " skipped)";
                }
                if (summary.getTestsFailedCount() > 0L) {
                    result = "FAIL";
                    this.fail = true;
                } else if (summary.getTestsFoundCount() == 0L) {
                    result = "NONE";
                    this.fail = true;
                } else if (summary.getTestsSucceededCount() == summary.getTestsFoundCount()) {
                    result = "PASS";
                } else if (summary.getTestsSkippedCount() > 0L) {
                    this.withIssues = true;
                }
            }
            this.out.println(result + "\t" + en.getKey() + "\t" + extra);
        }
        this.out.println();
        this.out.println("Supported capabilities:   " + this.supportedCapabilites);
        this.out.println("Unsupported capabilities: " + this.unsupportedCapabilites);
        this.out.println();
        if (this.fail) {
            this.out.println("Selftest FAILED");
        } else if (this.withIssues) {
            this.out.println("Selftest PASSED WITH ISSUES");
        } else {
            this.out.println("Selftest PASSED");
        }
    }

    private static Class<? extends Annotation> getAFUNIXSocketCapabilityRequirementClass() {
        try {
            return Class.forName("org.newsclub.net.unix.AFUNIXSocketCapabilityRequirement");
        }
        catch (ClassNotFoundException e1) {
            return null;
        }
    }

    private boolean checkIfCapabilitiesSupported(String className) {
        block7: {
            if (CAP_ANNOTATION_CLASS != null) {
                try {
                    Class<?> klass = Class.forName(className);
                    Annotation annotation = klass.getAnnotation(CAP_ANNOTATION_CLASS);
                    if (annotation == null) break block7;
                    try {
                        AFUNIXSocketCapability[] caps = (AFUNIXSocketCapability[])annotation.getClass().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                        if (caps != null) {
                            for (AFUNIXSocketCapability cap : caps) {
                                if (AFUNIXSocket.supports((AFUNIXSocketCapability)cap)) continue;
                                this.out.println("Skipping class " + className + "; unsupported capability: " + cap);
                                return false;
                            }
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    }
                }
                catch (ClassNotFoundException e) {
                    this.out.println("Class not found: " + className);
                    this.withIssues = true;
                }
            }
        }
        return true;
    }

    public void runTests(String module, String[] classesToTest) {
        Object summary;
        this.out.println("Testing \"" + module + "\"...");
        if (Boolean.valueOf(System.getProperty("selftest.skip." + module, "false")).booleanValue()) {
            this.out.println("Skipping module " + module + "; skipped by request");
            this.withIssues = true;
            summary = null;
        } else {
            CommandLineOptions options = new CommandLineOptions();
            options.setAnsiColorOutputDisabled(true);
            options.setTheme(Theme.ASCII);
            ArrayList<String> list = new ArrayList<String>(classesToTest.length);
            for (String className : classesToTest) {
                if (classesToTest == null || classesToTest.length == 0) continue;
                if (Boolean.valueOf(System.getProperty("selftest.skip." + className, "false")).booleanValue()) {
                    this.out.println("Skipping test class " + className + "; skipped by request");
                    this.withIssues = true;
                    continue;
                }
                if (!this.checkIfCapabilitiesSupported(className)) continue;
                list.add(className);
            }
            options.setSelectedClasses(list);
            try {
                summary = new ConsoleTestExecutor(options).execute(this.out);
            }
            catch (Exception e) {
                e.printStackTrace(this.out);
                summary = e;
            }
        }
        this.results.put(module, summary);
    }
}

