/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CancelAcceptTest
extends SocketTestBase {
    private boolean serverSocketClosed = false;

    @Test
    public void issue6test1() throws Exception {
        AFUNIXSocket sock3;
        this.serverSocketClosed = false;
        SocketTestBase.ServerThread st = new SocketTestBase.ServerThread(){

            @Override
            protected void handleConnection(Socket sock) throws IOException {
            }

            @Override
            protected void onServerSocketClose() {
                CancelAcceptTest.this.serverSocketClosed = true;
            }

            @Override
            protected void handleException(Exception e) {
            }
        };
        AFUNIXSocket sock2 = this.connectToServer();
        if (sock2 != null) {
            sock2.close();
        }
        if ((sock2 = this.connectToServer()) != null) {
            sock2.close();
        }
        ServerSocket servSock = st.getServerSocket();
        Assertions.assertFalse((this.serverSocketClosed && !servSock.isClosed() ? 1 : 0) != 0, (String)"ServerSocket should not be closed now");
        servSock.close();
        try {
            sock3 = this.connectToServer();
            if (sock3 != null) {
                sock3.close();
            }
            Assertions.fail((String)"Did not throw SocketException");
        }
        catch (SocketException sock3) {
            // empty catch block
        }
        Assertions.assertTrue((this.serverSocketClosed || servSock.isClosed() ? 1 : 0) != 0, (String)"ServerSocket should be closed now");
        try {
            sock3 = this.connectToServer();
            try {
                Assertions.fail((String)"ServerSocket should have been closed already");
            }
            finally {
                if (sock3 != null) {
                    sock3.close();
                }
            }
            Assertions.fail((String)"Did not throw SocketException");
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }
}

