/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.domain;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import javax.net.SocketFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketFactory;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.domain.AFUNIXAddressSpecifics;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN})
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION", "DMI_HARDCODED_ABSOLUTE_FILENAME"})
public final class SocketFactoryTest
extends SocketTestBase<AFUNIXSocketAddress> {
    public SocketFactoryTest() {
        super(AFUNIXAddressSpecifics.INSTANCE);
    }

    @Test
    public void testURISchemeCeateSocketThenConnect() throws Exception {
        AFUNIXSocketFactory.URIScheme factory = new AFUNIXSocketFactory.URIScheme();
        try (Socket sock = factory.createSocket();
             AFUNIXSocket socket = (AFUNIXSocket)sock;){
            Assertions.assertThrows(IllegalArgumentException.class, () -> socket.connect(null));
            Assertions.assertThrows(IllegalArgumentException.class, () -> socket.connect((SocketAddress)new InetSocketAddress("http://example.com./", 0)));
            Assertions.assertThrows(IllegalArgumentException.class, () -> socket.connect((SocketAddress)new InetSocketAddress("", 0)));
            Assertions.assertThrows(SocketException.class, () -> socket.connect((SocketAddress)new InetSocketAddress("file://", 0)));
            Assertions.assertThrows(SocketException.class, () -> socket.connect((SocketAddress)new InetSocketAddress("file://not-absolute", 0)));
            Assertions.assertThrows(SocketException.class, () -> socket.connect((SocketAddress)new InetSocketAddress("file:///", 0)));
        }
    }

    @Test
    public void testURISchemeCeateSocketWithIllegalArguments() throws Exception {
        AFUNIXSocketFactory.URIScheme factory = new AFUNIXSocketFactory.URIScheme();
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            try (Socket sock = factory.createSocket("file:///", 0, null, -1);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
    }

    @Test
    public void testURISchemeCeateSocketWithInvalidHostname() throws Exception {
        AFUNIXSocketFactory.URIScheme factory = new AFUNIXSocketFactory.URIScheme();
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket("", 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket("", 0, null, 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket(InetAddress.getByName(""), 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket(InetAddress.getLoopbackAddress(), 0, null, 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket("file:", 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket("file:/", 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket("file://", 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket("file://not-absolute", 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket("[", 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket("file%3A%2F%2F%", 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
    }

    @Test
    public void testURISchemeCeateSocketWithHostnameValidCases() throws Exception {
        AFUNIXSocketFactory.URIScheme factory = new AFUNIXSocketFactory.URIScheme();
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket("file:///", 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket("file://localhost/", 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket("[file:///]", 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket("[file:///", 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket("file%3A%2F%2F%2F", 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            try (Socket sock = factory.createSocket("file%3A%2F%2Flocalhost%2F", 0);){
                Assertions.fail((String)("Should not be reached: " + sock));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSystemProperty() throws Exception {
        AFUNIXSocketFactory.SystemProperty factory = new AFUNIXSocketFactory.SystemProperty();
        String hostnameToConnectTo = System.getProperty("org.newsclub.net.unix.socket.hostname", "localhost");
        String existingSocketDefault = System.getProperty("org.newsclub.net.unix.socket.default");
        try {
            System.clearProperty("org.newsclub.net.unix.socket.default");
            Assertions.assertThrows(IllegalStateException.class, () -> {
                try (Socket sock = factory.createSocket(hostnameToConnectTo, 0);){
                    Assertions.fail((String)("Should not be reached: " + sock));
                }
            });
            System.setProperty("org.newsclub.net.unix.socket.default", "");
            Assertions.assertThrows(IllegalStateException.class, () -> {
                try (Socket sock = factory.createSocket(hostnameToConnectTo, 0);){
                    Assertions.fail((String)("Should not be reached: " + sock));
                }
            });
            System.setProperty("org.newsclub.net.unix.socket.default", "/");
            Assertions.assertThrows(SocketException.class, () -> {
                try (Socket sock = factory.createSocket(hostnameToConnectTo, 0);){
                    Assertions.fail((String)("Should not be reached: " + sock));
                }
            });
        }
        finally {
            if (existingSocketDefault == null) {
                System.clearProperty("org.newsclub.net.unix.socket.default");
            } else {
                System.setProperty("org.newsclub.net.unix.socket.default", existingSocketDefault);
            }
        }
    }

    @Test
    public void testFactoryArg() throws Exception {
        String hostnameToConnectTo = System.getProperty("org.newsclub.net.unix.socket.hostname", "localhost");
        Assertions.assertThrows(SocketException.class, () -> {
            AFUNIXSocketFactory.FactoryArg factory = new AFUNIXSocketFactory.FactoryArg("/");
            Socket unused = factory.createSocket(hostnameToConnectTo, 0);
            if (unused != null) {
                unused.close();
            }
        });
        Assertions.assertThrows(SocketException.class, () -> {
            AFUNIXSocketFactory.FactoryArg factory = new AFUNIXSocketFactory.FactoryArg(new File("/"));
            Socket unused = factory.createSocket(hostnameToConnectTo, 0);
            if (unused != null) {
                unused.close();
            }
        });
    }

    @Test
    public void testReflection() throws Exception {
        Assertions.assertEquals((Object)AFUNIXSocketFactory.SystemProperty.class.getName(), (Object)Class.forName("org.newsclub.net.unix.AFUNIXSocketFactory$SystemProperty").getName());
        Assertions.assertEquals((Object)AFUNIXSocketFactory.URIScheme.class.getName(), (Object)Class.forName("org.newsclub.net.unix.AFUNIXSocketFactory$URIScheme").getName());
        Assertions.assertEquals((Object)AFUNIXSocketFactory.FactoryArg.class.getName(), (Object)Class.forName("org.newsclub.net.unix.AFUNIXSocketFactory$FactoryArg").getName());
        SocketFactoryTest.newInstance("org.newsclub.net.unix.AFUNIXSocketFactory$SystemProperty", null);
        SocketFactoryTest.newInstance("org.newsclub.net.unix.AFUNIXSocketFactory$URIScheme", null);
        SocketFactoryTest.newInstance("org.newsclub.net.unix.AFUNIXSocketFactory$FactoryArg", "/");
        SocketFactoryTest.newInstance("org.newsclub.net.unix.AFUNIXSocketFactory$FactoryArg", new File("/"));
    }

    private static SocketFactory newInstance(String className, Object arg) throws Exception {
        Class<?> klazz = Class.forName(className);
        Assertions.assertTrue((boolean)SocketFactory.class.isAssignableFrom(klazz));
        Object instance = arg == null ? klazz.getConstructor(new Class[0]).newInstance(new Object[0]) : klazz.getConstructor(arg.getClass()).newInstance(arg);
        return (SocketFactory)instance;
    }
}

