/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class TestUtil {
    private static final boolean IS_HAIKU_OS = "Haiku".equals(System.getProperty("os.name"));

    private TestUtil() {
        throw new IllegalStateException("No instances");
    }

    public static boolean isHaikuOS() {
        return IS_HAIKU_OS;
    }

    private static void handleBug(String id, Throwable e) throws Exception {
        String key = "selftest." + id;
        switch (System.getProperty(key, "")) {
            case "dump": {
                e.printStackTrace();
                break;
            }
            case "fail": {
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new IllegalStateException(e);
            }
            case "": {
                return;
            }
            default: {
                System.err.println("Invalid value for System property " + key);
            }
        }
    }

    public static Exception haikuBug18534(Throwable e) throws Exception {
        TestUtil.handleBug("haikuBug18534", e);
        return new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, "AF_UNIX support is buggy in this Haiku release; see https://dev.haiku-os.org/ticket/18534", e);
    }

    public static Exception haikuBug18535(Throwable e) throws Exception, Error {
        TestUtil.handleBug("haikuBug18535", e);
        return new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, "AF_UNIX datagram support is buggy in this Haiku release or environment; see https://dev.haiku-os.org/ticket/18535", e);
    }
}

