/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import com.kohlschutter.testutil.TestStackTraceUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public abstract class CancelAcceptTest<A extends SocketAddress>
extends SocketTestBase<A> {
    protected static final String NO_SOCKETEXCEPTION_CLOSED_SERVER = "Did not throw SocketException when connecting to closed server socket";

    protected CancelAcceptTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @Test
    public void issue6test1() throws Exception {
        block35: {
            final AtomicBoolean serverSocketClosed = new AtomicBoolean(false);
            final AtomicBoolean ignoreServerSocketClosedException = new AtomicBoolean(false);
            try (SocketTestBase.ServerThread serverThread = new SocketTestBase.ServerThread(this){
                final /* synthetic */ CancelAcceptTest this$0;
                {
                    this.this$0 = this$0;
                    super(this$0);
                }

                @Override
                protected void handleConnection(Socket sock) throws IOException {
                }

                @Override
                protected void onServerSocketClose() {
                    serverSocketClosed.set(true);
                }

                @Override
                protected SocketTestBase.ExceptionHandlingDecision handleException(Exception e) {
                    ServerSocket serverSocket;
                    if (ignoreServerSocketClosedException.get() && e instanceof SocketException && (serverSocket = this.getServerSocket()) != null && serverSocket.isClosed()) {
                        return SocketTestBase.ExceptionHandlingDecision.IGNORE;
                    }
                    return SocketTestBase.ExceptionHandlingDecision.RAISE;
                }
            };){
                String noticeNoSocketException2;
                try (Socket sock = this.connectTo(serverThread.getServerAddress());){
                    Objects.requireNonNull(sock);
                }
                sock = this.connectTo(serverThread.getServerAddress());
                try {
                    Objects.requireNonNull(sock);
                }
                finally {
                    if (sock != null) {
                        sock.close();
                    }
                }
                ServerSocket serverSocket = serverThread.getServerSocket();
                Assertions.assertFalse((serverSocketClosed.get() && !serverSocket.isClosed() ? 1 : 0) != 0, (String)"ServerSocket should not be closed now");
                ignoreServerSocketClosedException.set(true);
                SocketAddress serverAddress = serverThread.getServerAddress();
                serverSocket.close();
                try {
                    for (int i = 0; i < 2; ++i) {
                        Socket unused = this.connectTo(serverAddress);
                        if (unused == null) continue;
                        unused.close();
                    }
                    noticeNoSocketException2 = this.checkKnownConditionDidNotThrowSocketException();
                    if (noticeNoSocketException2 != null) {
                        throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_WITH_ISSUES, noticeNoSocketException2);
                    }
                    Assertions.fail((String)NO_SOCKETEXCEPTION_CLOSED_SERVER);
                }
                catch (SocketException noticeNoSocketException2) {
                    // empty catch block
                }
                Assertions.assertTrue((serverSocketClosed.get() || serverSocket.isClosed() ? 1 : 0) != 0, (String)"ServerSocket should be closed now");
                try {
                    try (Socket sock = this.connectTo(serverAddress);){
                        Objects.requireNonNull(sock);
                        Assertions.fail((String)"ServerSocket should have been closed already");
                    }
                    noticeNoSocketException2 = this.checkKnownConditionDidNotThrowSocketException();
                    if (noticeNoSocketException2 == null) {
                        Assertions.fail((String)NO_SOCKETEXCEPTION_CLOSED_SERVER);
                        break block35;
                    }
                    throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_WITH_ISSUES, noticeNoSocketException2);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
            catch (SocketException e) {
                TestStackTraceUtil.printStackTrace((Throwable)e);
            }
        }
    }

    protected String checkKnownConditionDidNotThrowSocketException() {
        return null;
    }
}

