/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.mysql;

import com.kohlschutter.testutil.TestAbortedNotAnIssueException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class MysqlCredentials {
    private final String mysqlSock;
    private final String user;
    private final String password;
    private final String database;

    private MysqlCredentials(String mysqlSock, String user, String password, String database) {
        this.mysqlSock = mysqlSock;
        this.user = user;
        this.password = password;
        this.database = database;
    }

    public static MysqlCredentials getCredentials() throws TestAbortedNotAnIssueException {
        String mysqlSock = System.getProperty("selftest.mysql.sock", "");
        if (mysqlSock.isEmpty()) {
            throw new TestAbortedNotAnIssueException("Specify -Dselftest.mysql.sock=/tmp/mysql.sock or similar to enable test");
        }
        String user = System.getProperty("selftest.mysql.user", "root");
        String password = System.getProperty("selftest.mysql.password", "");
        String database = System.getProperty("selftest.mysql.database", "mysql");
        return new MysqlCredentials(mysqlSock, user, password, database);
    }

    public String getMysqlSock() {
        return this.mysqlSock;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String toString() {
        return "-Dselftest.mysql.sock=" + this.mysqlSock + " -Dselftest.mysql.user=" + this.user + " -Dselftest.mysql.password=" + this.password + " -Dselftest.mysql.database=" + this.database;
    }
}

