/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.newsclub.net.unix.AFTIPCSocketAddressTest;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketAddressTest;
import org.newsclub.net.unix.BuildPropertiesTest;
import org.newsclub.net.unix.FileDescriptorCastTest;
import org.newsclub.net.unix.InetAddressTest;
import org.newsclub.net.unix.NativeLibraryLoader;
import org.newsclub.net.unix.PipeTest;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.ThreadUtil;
import org.newsclub.net.unix.domain.AbstractNamespaceTest;
import org.newsclub.net.unix.domain.AcceptTimeoutTest;
import org.newsclub.net.unix.domain.AvailableTest;
import org.newsclub.net.unix.domain.BufferOverflowTest;
import org.newsclub.net.unix.domain.CancelAcceptTest;
import org.newsclub.net.unix.domain.DatagramSocketTest;
import org.newsclub.net.unix.domain.EndOfFileTest;
import org.newsclub.net.unix.domain.FileDescriptorsTest;
import org.newsclub.net.unix.domain.InterruptTest;
import org.newsclub.net.unix.domain.MassiveParallelTest;
import org.newsclub.net.unix.domain.PeerCredentialsTest;
import org.newsclub.net.unix.domain.ReadWriteTest;
import org.newsclub.net.unix.domain.ServerSocketCloseTest;
import org.newsclub.net.unix.domain.ServerSocketTest;
import org.newsclub.net.unix.domain.SoTimeoutTest;
import org.newsclub.net.unix.domain.SocketAddressTest;
import org.newsclub.net.unix.domain.SocketFactoryTest;
import org.newsclub.net.unix.domain.SocketPairTest;
import org.newsclub.net.unix.domain.SocketTest;
import org.newsclub.net.unix.domain.StandardSocketOptionsTest;
import org.newsclub.net.unix.domain.TcpNoDelayTest;
import org.newsclub.net.unix.domain.UnixDomainSocketAddressTest;
import org.newsclub.net.unix.java.InterruptIssue158Test;
import org.newsclub.net.unix.java.SelectorTest;
import org.newsclub.net.unix.java.SocketChannelTest;
import org.newsclub.net.unix.java.ThroughputTest;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SelftestProvider {
    private static final String COMMON = "junixsocket-common";
    private static final String COMMON_JAVA_INET = "junixsocket-common.JavaInet";
    private static final String COMMON_JEP380 = "junixsocket-common.JEP380";
    final Map<String, LinkedHashSet<Class<?>>> testMap = new LinkedHashMap();

    public SelftestProvider() {
        this.registerTest(COMMON, AFTIPCSocketAddressTest.class);
        this.registerTest(COMMON, AFUNIXSocketAddressTest.class);
        this.registerTest(AbstractNamespaceTest.class);
        this.registerTest(AcceptTimeoutTest.class);
        this.registerTest(AvailableTest.class);
        this.registerTest(COMMON, BuildPropertiesTest.class);
        this.registerTest(BufferOverflowTest.class);
        this.registerTest(CancelAcceptTest.class);
        this.registerTest(DatagramSocketTest.class);
        this.registerTest(EndOfFileTest.class);
        this.registerTest(COMMON, FileDescriptorCastTest.class);
        this.registerTest(COMMON, org.newsclub.net.unix.domain.FileDescriptorCastTest.class);
        this.registerTest(FileDescriptorsTest.class);
        this.registerTest(InetAddressTest.class);
        this.registerTest(InterruptTest.class);
        this.registerTest(org.newsclub.net.unix.domain.InterruptIssue158Test.class);
        this.registerTestJavaInet(InterruptIssue158Test.class);
        this.registerTestJEP380(org.newsclub.net.unix.jep380.InterruptIssue158Test.class);
        this.registerTestJavaInet(org.newsclub.net.unix.java.InterruptTest.class);
        this.registerTest(MassiveParallelTest.class);
        this.registerTest(PeerCredentialsTest.class);
        this.registerTest(COMMON, PipeTest.class);
        this.registerTest(ReadWriteTest.class);
        this.registerTest(org.newsclub.net.unix.domain.SelectorTest.class);
        this.registerTestJavaInet(SelectorTest.class);
        this.registerTest(ServerSocketCloseTest.class);
        this.registerTest(ServerSocketTest.class);
        this.registerTest(SocketAddressTest.class);
        this.registerTest(org.newsclub.net.unix.domain.SocketChannelTest.class);
        this.registerTestJavaInet(SocketChannelTest.class);
        this.registerTestJEP380(org.newsclub.net.unix.jep380.SocketChannelTest.class);
        this.registerTest(SocketFactoryTest.class);
        this.registerTest(SocketPairTest.class);
        this.registerTest(SocketTest.class);
        this.registerTest(SoTimeoutTest.class);
        this.registerTest(StandardSocketOptionsTest.class);
        this.registerTest(TcpNoDelayTest.class);
        this.registerTest(org.newsclub.net.unix.domain.ThroughputTest.class);
        this.registerTestJavaInet(ThroughputTest.class);
        this.registerTest(UnixDomainSocketAddressTest.class);
    }

    public Set<String> modulesDisabledByDefault() {
        return new HashSet<String>(Arrays.asList(COMMON_JAVA_INET, COMMON_JEP380));
    }

    private void registerTest(Class<? extends SocketTestBase<AFUNIXSocketAddress>> testUnixDomain) {
        this.registerTest(COMMON, testUnixDomain);
    }

    private void registerTestJavaInet(Class<? extends SocketTestBase<InetSocketAddress>> testJava) {
        this.registerTest(COMMON_JAVA_INET, testJava);
    }

    private void registerTestJEP380(Class<? extends SocketTestBase<SocketAddress>> testJava) {
        this.registerTest(COMMON_JEP380, testJava);
    }

    private void registerTest(String group, Class<?> test) {
        if (test != null) {
            this.testMap.computeIfAbsent(group, key -> new LinkedHashSet()).add(test);
        }
    }

    public Map<String, Class<?>[]> tests() {
        LinkedHashMap<String, Class<?>[]> tests = new LinkedHashMap<String, Class<?>[]>();
        this.testMap.forEach((key, set) -> tests.put((String)key, set.toArray(new Class[0])));
        return tests;
    }

    public void printAdditionalProperties(PrintWriter out) {
        out.println("Native architecture: " + String.valueOf(NativeLibraryLoader.getArchitectureAndOS()));
        out.println("Virtual threads support enabled: " + ThreadUtil.isVirtualThreadSupported());
        if (System.getProperty("org.newsclub.net.unix.virtual-threads") == null) {
            if (ThreadUtil.isVirtualThreadSupported()) {
                out.println("   ... disable with -Dorg.newsclub.net.unix.virtual-threads=false");
            }
        } else if (!ThreadUtil.isVirtualThreadSupported()) {
            out.println("   ... remove -Dorg.newsclub.net.unix.virtual-threads=false to re-enable");
        }
    }

    public static void main(String[] args) {
        new SelftestProvider().printAdditionalProperties(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()), true));
    }
}

