/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.mysql;

import com.mysql.cj.conf.DefaultPropertySet;
import com.mysql.cj.conf.PropertySet;
import com.mysql.cj.conf.StringPropertyDefinition;
import java.io.IOException;
import java.net.SocketAddress;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.mysql.AFUNIXDatabaseSocketFactoryCJ;
import org.newsclub.net.mysql.MysqlSocketFactoryTestBase;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXDatabaseSocketFactoryCJTest
extends MysqlSocketFactoryTestBase {
    @Test
    public void testConnectTimeout() throws Exception {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.ofNewTempFile();
        try (AFUNIXServerSocket serverSocket = AFUNIXServerSocket.newInstance();){
            serverSocket.bind((SocketAddress)addr, 1);
            AFUNIXDatabaseSocketFactoryCJ sf = new AFUNIXDatabaseSocketFactoryCJ();
            DefaultPropertySet props = new DefaultPropertySet();
            props.addProperty(new StringPropertyDefinition("junixsocket.file", "junixsocket.file", addr.getFile().toString(), true, "description", "0", "category", 1).createRuntimeProperty());
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
                try {
                    sf.connect("localhost", 0, (PropertySet)props, 1);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    protected String socketFactory() {
        return "org.newsclub.net.mysql.AFUNIXDatabaseSocketFactoryCJ";
    }
}

