/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import org.newsclub.net.unix.StackTraceUtil;
import org.newsclub.net.unix.rmi.AFNaming;
import org.newsclub.net.unix.rmi.AFRMIService;
import org.newsclub.net.unix.rmi.ShutdownException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class AFRMIServiceImpl
implements AFRMIService {
    private final BitSet ports = new BitSet(1000);
    private final WeakReference<AFNaming> naming;
    private final List<WeakReference<Closeable>> closeAtShutdown = new ArrayList<WeakReference<Closeable>>();

    public AFRMIServiceImpl(AFNaming naming) {
        this.naming = new WeakReference<AFNaming>(naming);
    }

    @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"})
    private int randomPort() {
        int maxRandom = this.ports.size();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 3; ++i) {
            int port = this.ports.nextClearBit(((Random)random).nextInt(maxRandom));
            if (port < maxRandom) {
                return port;
            }
            maxRandom = port;
            if (maxRandom == 0) break;
        }
        return this.ports.nextClearBit(0);
    }

    @Override
    public synchronized int newPort() throws IOException {
        int port = this.randomPort();
        this.ports.set(port);
        return port += 110000;
    }

    @Override
    public synchronized void returnPort(int port) throws IOException {
        this.ports.clear(port - 110000);
    }

    @Override
    public IntStream openPorts() throws RemoteException {
        return this.ports.stream().map(v -> v + 110000);
    }

    @Override
    public void shutdown() throws RemoteException {
        AFNaming namingInstance = (AFNaming)this.naming.get();
        if (namingInstance != null) {
            if (!namingInstance.isRemoteShutdownAllowed()) {
                throw new ServerException("Remote shutdown is disabled");
            }
            try {
                namingInstance.shutdownRegistry();
            }
            catch (ShutdownException shutdownException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isShutdownAllowed() throws RemoteException {
        AFNaming namingInstance = (AFNaming)this.naming.get();
        if (namingInstance != null) {
            return namingInstance.isRemoteShutdownAllowed();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerForShutdown(Closeable closeable) throws RemoteException {
        List<WeakReference<Closeable>> list = this.closeAtShutdown;
        synchronized (list) {
            this.unregisterForShutdown(closeable);
            this.closeAtShutdown.add(new WeakReference<Closeable>(closeable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterForShutdown(Closeable closeable) throws RemoteException {
        List<WeakReference<Closeable>> list = this.closeAtShutdown;
        synchronized (list) {
            Objects.requireNonNull(closeable);
            Iterator<WeakReference<Closeable>> it = this.closeAtShutdown.iterator();
            while (it.hasNext()) {
                if (!closeable.equals(it.next().get())) continue;
                it.remove();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownRegisteredCloseables() {
        ArrayList<WeakReference<Closeable>> list;
        List<WeakReference<Closeable>> list2 = this.closeAtShutdown;
        synchronized (list2) {
            list = new ArrayList<WeakReference<Closeable>>(this.closeAtShutdown);
            this.closeAtShutdown.clear();
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        for (WeakReference weakReference : list) {
            executor.execute(() -> {
                Closeable cl = (Closeable)ref.get();
                if (cl == null) {
                    return;
                }
                try {
                    cl.close();
                }
                catch (NoSuchObjectException noSuchObjectException) {
                }
                catch (IOException e) {
                    StackTraceUtil.printStackTrace((Throwable)e);
                }
            });
        }
        executor.shutdown();
    }
}

