/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.Closeable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.rmi.NotBoundException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.StackTraceUtil;
import org.newsclub.net.unix.rmi.AFNaming;
import org.newsclub.net.unix.rmi.AFRMIService;
import org.newsclub.net.unix.rmi.ShutdownException;
import org.newsclub.net.unix.rmi.ShutdownHookSupport;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AFRMISocketFactory
extends RMISocketFactory
implements Externalizable,
Closeable {
    private static final long serialVersionUID = 1L;
    private transient AFRMIService rmiService = null;
    private Externables externables;
    private final transient Map<Integer, AFServerSocket<?>> openServerSockets = new HashMap();
    private final transient Set<AFSocket<?>> openSockets = new HashSet();

    public AFRMISocketFactory() {
        this(null, null, null);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public AFRMISocketFactory(AFNaming naming, RMIClientSocketFactory defaultClientFactory, RMIServerSocketFactory defaultServerFactory) {
        this.externables = new Externables(naming, defaultClientFactory, defaultServerFactory);
        this.closeUponRuntimeShutdown();
    }

    private void closeUponRuntimeShutdown() {
        ShutdownHookSupport.addWeakShutdownHook(new ShutdownHookSupport.ShutdownHook(){

            @Override
            public void onRuntimeShutdown(Thread thread) {
                try {
                    AFRMISocketFactory.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    protected abstract AFSocketAddress newSocketAddress(int var1) throws IOException;

    protected abstract AFSocket<?> newConnectedSocket(AFSocketAddress var1) throws IOException;

    private synchronized Externables getExternables() {
        return this.externables;
    }

    private synchronized void setExternable(Externables externable) {
        this.externables = externable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(String host, int port) throws IOException {
        RMIClientSocketFactory cf = this.getExternables().defaultClientFactory;
        if (cf != null && port < 100000) {
            return cf.createSocket(host, port);
        }
        AFSocketAddress addr = this.newSocketAddress(port);
        AFSocket<?> socket = this.newConnectedSocket(addr);
        Set<AFSocket<?>> set = this.openSockets;
        synchronized (set) {
            this.openSockets.add(socket);
        }
        socket.addCloseable(() -> {
            Set<AFSocket<?>> set = this.openSockets;
            synchronized (set) {
                this.openSockets.remove(socket);
            }
        });
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        AFNaming aFNaming = this.getExternables().naming;
        synchronized (aFNaming) {
            this.rmiService = null;
            this.closeServerSockets();
            this.closeSockets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AFRMIService getRmiService() throws IOException {
        AFNaming naming;
        AFNaming aFNaming = naming = this.getExternables().naming;
        synchronized (aFNaming) {
            if (this.rmiService == null) {
                try {
                    this.rmiService = naming.getRMIService();
                }
                catch (NotBoundException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }
            return this.rmiService;
        }
    }

    @Deprecated
    protected int newPort() throws IOException {
        return this.getRmiService().newPort();
    }

    protected PortLease newPortLease() throws IOException {
        AFRMIService service = this.getRmiService();
        int port = service.newPort();
        return new PortLease(port, service);
    }

    @Deprecated
    protected void returnPort(int port) throws IOException {
        try {
            this.getRmiService().returnPort(port);
        }
        catch (ShutdownException shutdownException) {
        }
        catch (IOException e) {
            StackTraceUtil.printStackTrace((Throwable)e);
        }
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        if (port == 0) {
            PortLease portLease = this.newPortLease();
            port = portLease.getPort();
            AFSocketAddress addr = this.newSocketAddress(port);
            AFServerSocket ass = addr.getAddressFamily().newServerSocket();
            ass.addCloseable((Closeable)portLease);
            ass.setReuseAddress(true);
            ass.setDeleteOnClose(true);
            ass.bind((SocketAddress)addr);
            if (port >= 100000) {
                ass.addCloseable((Closeable)new ServerSocketCloseable(ass, port));
            }
            return ass;
        }
        RMIServerSocketFactory sf = this.getExternables().defaultServerFactory;
        if (sf != null && port < 100000) {
            return sf.createServerSocket(port);
        }
        AFSocketAddress addr = this.newSocketAddress(port);
        AFServerSocket socket = addr.getAddressFamily().newServerSocket();
        socket.setDeleteOnClose(true);
        socket.setReuseAddress(true);
        socket.bind((SocketAddress)addr);
        socket.addCloseable((Closeable)new ServerSocketCloseable(socket, port));
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeServerSockets() throws IOException {
        HashMap map;
        Map<Integer, AFServerSocket<?>> map2 = this.openServerSockets;
        synchronized (map2) {
            map = new HashMap(this.openServerSockets);
        }
        IOException ex = null;
        for (Map.Entry en : map.entrySet()) {
            try {
                ((AFServerSocket)en.getValue()).close();
            }
            catch (ShutdownException shutdownException) {
            }
            catch (IOException e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        Map<Integer, AFServerSocket<?>> map3 = this.openServerSockets;
        synchronized (map3) {
            this.openServerSockets.clear();
        }
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSockets() {
        HashSet set;
        Set<AFSocket<?>> set2 = this.openSockets;
        synchronized (set2) {
            set = new HashSet(this.openSockets);
        }
        for (AFSocket aFSocket : set) {
            try {
                aFSocket.close();
            }
            catch (IOException iOException) {}
        }
        set2 = this.openSockets;
        synchronized (set2) {
            this.openSockets.clear();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setExternable(new Externables(this.readNamingInstance(in), (RMIClientSocketFactory)in.readObject(), (RMIServerSocketFactory)in.readObject()));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Externables ext = this.getExternables();
        this.writeNamingInstance(out, ext.naming);
        out.writeObject(ext.defaultClientFactory);
        out.writeObject(ext.defaultServerFactory);
    }

    protected abstract AFNaming readNamingInstance(ObjectInput var1) throws IOException;

    protected abstract void writeNamingInstance(ObjectOutput var1, AFNaming var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalServer(int port) {
        if (port < 100000) {
            return false;
        }
        Map<Integer, AFServerSocket<?>> map = this.openServerSockets;
        synchronized (map) {
            return this.openServerSockets.containsKey(port);
        }
    }

    protected AFNaming getNaming() {
        return this.getExternables().naming;
    }

    abstract boolean hasRegisteredPort(int var1);

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Externables {
        private final AFNaming naming;
        private final RMIClientSocketFactory defaultClientFactory;
        private final RMIServerSocketFactory defaultServerFactory;

        private Externables(AFNaming naming, RMIClientSocketFactory defaultClientFactory, RMIServerSocketFactory defaultServerFactory) {
            this.naming = naming;
            this.defaultClientFactory = defaultClientFactory;
            this.defaultServerFactory = defaultServerFactory;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static final class PortLease
    implements Closeable {
        private final int port;
        private final AFRMIService rmiService;

        private PortLease(int port, AFRMIService rmiService) {
            this.port = port;
            this.rmiService = rmiService;
        }

        @Override
        public void close() throws IOException {
            this.rmiService.returnPort(this.getPort());
        }

        public int getPort() {
            return this.port;
        }

        public AFRMIService getRmiService() {
            return this.rmiService;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class ServerSocketCloseable
    implements Closeable {
        private final int port;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ServerSocketCloseable(AFServerSocket<?> socket, int port) {
            this.port = port;
            Map<Integer, AFServerSocket<?>> map = AFRMISocketFactory.this.openServerSockets;
            synchronized (map) {
                AFRMISocketFactory.this.openServerSockets.put(port, socket);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Map<Integer, AFServerSocket<?>> map = AFRMISocketFactory.this.openServerSockets;
            synchronized (map) {
                AFRMISocketFactory.this.openServerSockets.remove(this.port);
            }
        }
    }
}

