/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class AFUNIXNamingRef {
    final File socketDir;
    private final int port;
    private final String socketPrefix;
    private final String socketSuffix;

    AFUNIXNamingRef(File socketDir, int port, String socketPrefix, String socketSuffix) throws RemoteException {
        try {
            this.socketDir = socketDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        this.port = port;
        this.socketPrefix = socketPrefix == null ? "" : socketPrefix;
        this.socketSuffix = socketSuffix == null ? ".rmi" : socketSuffix;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.port;
        result = 31 * result + (this.socketDir == null ? 0 : this.socketDir.hashCode());
        result = 31 * result + (this.socketPrefix == null ? 0 : this.socketPrefix.hashCode());
        result = 31 * result + (this.socketSuffix == null ? 0 : this.socketSuffix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AFUNIXNamingRef)) {
            return false;
        }
        AFUNIXNamingRef other = (AFUNIXNamingRef)obj;
        if (this.port != other.port) {
            return false;
        }
        if (this.socketDir == null ? other.socketDir != null : !this.socketDir.equals(other.socketDir)) {
            return false;
        }
        if (this.socketPrefix == null ? other.socketPrefix != null : !this.socketPrefix.equals(other.socketPrefix)) {
            return false;
        }
        return !(this.socketSuffix == null ? other.socketSuffix != null : !this.socketSuffix.equals(other.socketSuffix));
    }
}

