/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.jetty;

import java.io.IOException;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.SelectorManager;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.jetty.AFSocketConfigurator;
import org.newsclub.net.unix.jetty.AFSocketConfiguratorWithTransport;
import org.newsclub.net.unix.jetty.JettyCompat;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFSocketClientConnector
extends ClientConnector {
    private final AFAddressFamily<?> addressFamily;

    private AFSocketClientConnector(AFSocketAddress addr) {
        super(AFSocketClientConnector.configuratorFor(addr));
        this.addressFamily = addr.getAddressFamily();
    }

    public static ClientConnector withSocketAddress(AFSocketAddress addr) {
        return new AFSocketClientConnector(addr);
    }

    protected SelectorManager newSelectorManager() {
        return new ClientConnector.ClientSelectorManager(this.getExecutor(), this.getScheduler(), this.getSelectors()){

            protected Selector newSelector() throws IOException {
                SelectorProvider provider = AFSocketClientConnector.this.addressFamily.getSelectorProvider();
                return provider.openSelector();
            }
        };
    }

    private static ClientConnector.Configurator configuratorFor(AFSocketAddress addr) {
        if (JettyCompat.hasTransportClass()) {
            return new AFSocketConfiguratorWithTransport(addr);
        }
        return new AFSocketConfigurator(addr);
    }
}

