/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.jetty;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Map;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.SelectorManager;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketChannel;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFSocketClientConnector
extends ClientConnector {
    private final AFAddressFamily<?> addressFamily;

    private AFSocketClientConnector(AFSocketAddress addr) {
        super(AFSocketClientConnector.configuratorFor(addr));
        this.addressFamily = addr.getAddressFamily();
    }

    public static ClientConnector withSocketAddress(AFSocketAddress addr) {
        return new AFSocketClientConnector(addr);
    }

    protected SelectorManager newSelectorManager() {
        return new ClientConnector.ClientSelectorManager(this.getExecutor(), this.getScheduler(), this.getSelectors()){

            protected Selector newSelector() throws IOException {
                SelectorProvider provider = AFSocketClientConnector.this.addressFamily.getSelectorProvider();
                return provider.openSelector();
            }
        };
    }

    private static ClientConnector.Configurator configuratorFor(final AFSocketAddress addr) {
        return new ClientConnector.Configurator(){

            public ClientConnector.Configurator.ChannelWithAddress newChannelWithAddress(ClientConnector clientConnector, SocketAddress address, Map<String, Object> context) throws IOException {
                AFSocketChannel socketChannel = addr.getAddressFamily().newSocketChannel();
                return new ClientConnector.Configurator.ChannelWithAddress((SelectableChannel)socketChannel, (SocketAddress)addr);
            }
        };
    }
}

