/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.jetty;

import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import org.eclipse.jetty.io.DatagramChannelEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.io.Transport;
import org.eclipse.jetty.util.thread.Scheduler;
import org.newsclub.net.unix.AFSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFSocketTransport
extends Transport.Socket {
    private final AFSocketAddress socketAddress;

    private AFSocketTransport(AFSocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    public static AFSocketTransport withSocketChannel(AFSocketAddress addr) {
        return new WithSocketChannel(addr);
    }

    public static AFSocketTransport withDatagramChannel(AFSocketAddress addr) {
        return new WithDatagramChannel(addr);
    }

    public AFSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public int hashCode() {
        return Objects.hash(this.socketAddress);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AFSocketTransport) {
            return Objects.equals(this.socketAddress, ((AFSocketTransport)((Object)obj)).socketAddress);
        }
        return false;
    }

    public String toString() {
        return super.toString() + "[" + this.socketAddress.toString() + "]";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class WithSocketChannel
    extends AFSocketTransport {
        public WithSocketChannel(AFSocketAddress address) {
            super(address);
        }

        public SelectableChannel newSelectableChannel() throws IOException {
            return this.getSocketAddress().getAddressFamily().getSelectorProvider().openSocketChannel();
        }

        public EndPoint newEndPoint(Scheduler scheduler, ManagedSelector selector, SelectableChannel selectable, SelectionKey selectionKey) {
            return new SocketChannelEndPoint((SocketChannel)selectable, selector, selectionKey, scheduler);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class WithDatagramChannel
    extends AFSocketTransport {
        public WithDatagramChannel(AFSocketAddress address) {
            super(address);
        }

        public SelectableChannel newSelectableChannel() throws IOException {
            return this.getSocketAddress().getAddressFamily().getSelectorProvider().openDatagramChannel();
        }

        public EndPoint newEndPoint(Scheduler scheduler, ManagedSelector selector, SelectableChannel selectable, SelectionKey selectionKey) {
            return new DatagramChannelEndPoint((DatagramChannel)selectable, selector, selectionKey, scheduler);
        }
    }
}

