/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.rmi.fd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.NotBoundException;
import org.newsclub.net.unix.demo.rmi.services.StreamService;
import org.newsclub.net.unix.rmi.AFRegistry;
import org.newsclub.net.unix.rmi.AFUNIXNaming;
import org.newsclub.net.unix.rmi.RemoteCloseable;
import org.newsclub.net.unix.rmi.RemoteFileInput;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class StreamClient {
    private StreamClient() {
        throw new IllegalStateException("No instances");
    }

    public static void main(String[] args) throws IOException, NotBoundException {
        if (args.length != 1) {
            System.err.println("Usage: StreamClient <path-to-file>");
            System.exit(1);
            return;
        }
        if ("--help".equals(args[0]) || "-h".equals(args[0])) {
            System.out.println("Usage: StreamClient <path-to-file>");
            System.out.println();
            System.out.println("Examples:");
            System.out.println("    StreamClient /etc/hosts");
            System.out.println("    StreamClient /etc/master.passwd");
        }
        AFUNIXNaming naming = AFUNIXNaming.getInstance();
        AFRegistry registry = naming.getRegistry();
        StreamService obj = (StreamService)registry.lookup("streamService");
        File file = new File(args[0]);
        System.out.println("Trying to read " + String.valueOf(file));
        try (RemoteCloseable<RemoteFileInput> rc = obj.openForReading(file);
             RemoteFileInput rfin = (RemoteFileInput)rc.get();
             FileInputStream fin = rfin.asFileInputStream();){
            int len;
            byte[] data = new byte[4096];
            while ((len = fin.read(data)) != -1) {
                System.out.write(data, 0, len);
            }
        }
    }
}

