/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.ssl;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.DestroyFailedException;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.FileDescriptorCast;
import org.newsclub.net.unix.server.AFSocketServer;
import org.newsclub.net.unix.ssl.SNIHostnameCapture;
import org.newsclub.net.unix.ssl.SSLContextBuilder;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SSLDemoServer {
    public static void main(String[] args) throws InterruptedException, IOException, GeneralSecurityException, DestroyFailedException {
        AFUNIXSocketAddress addr = AFUNIXSocketAddress.of((File)new File("/tmp/ssldemo"));
        final SSLSocketFactory serverSocketFactory = SSLContextBuilder.forServer().withKeyStore(new File("juxserver.p12"), () -> "serverpass".toCharArray()).withTrustStore(new File("juxserver.truststore"), () -> "servertrustpass".toCharArray()).withDefaultSSLParameters(p -> {}).buildAndDestroyBuilder().getSocketFactory();
        AFSocketServer<AFUNIXSocketAddress> server = new AFSocketServer<AFUNIXSocketAddress>(addr){
            final SNIMatcher sniHostnameMatcher;
            {
                super((AFSocketAddress)arg0);
                this.sniHostnameMatcher = SNIHostnameCapture.ACCEPT_ANY_HOSTNAME;
            }

            protected void doServeSocket(AFSocket<? extends AFUNIXSocketAddress> plainSocket) throws IOException {
                block26: {
                    try (SSLSocket sslSocket = (SSLSocket)serverSocketFactory.createSocket((Socket)plainSocket, "localhost.junixsocket", plainSocket.getPort(), false);){
                        SNIHostnameCapture sniHostname = SNIHostnameCapture.configure((SSLSocket)sslSocket, (SNIMatcher)this.sniHostnameMatcher);
                        plainSocket.setAncillaryReceiveBufferSize(1);
                        sslSocket.startHandshake();
                        try {
                            if (sniHostname.isComplete(1L, TimeUnit.SECONDS)) {
                                System.out.println("Requested SNI hostname: " + sniHostname.getHostname());
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        try (InputStream in = sslSocket.getInputStream();
                             OutputStream out = sslSocket.getOutputStream();){
                            System.out.println("Received byte: " + Integer.toHexString(in.read()));
                            System.out.println("Sending hello...");
                            out.write("Hello World".getBytes(StandardCharsets.UTF_8));
                            FileDescriptor[] fds = ((AFUNIXSocket)plainSocket).getReceivedFileDescriptors();
                            if (fds.length <= 0) break block26;
                            System.out.println("File descriptor received: " + Arrays.asList(fds));
                            System.out.println("Sending an extra message directly to a FileDescriptor of the other process...");
                            try (PrintStream ps = new PrintStream((OutputStream)FileDescriptorCast.using((FileDescriptor)fds[0]).as(OutputStream.class), true, Charset.defaultCharset().name());){
                                ps.println("Greetings from the server, right to your stderr");
                            }
                        }
                    }
                }
            }

            protected void onServingException(AFSocket<? extends AFUNIXSocketAddress> socket, Exception e) {
                e.printStackTrace();
            }
        };
        server.startAndWaitToBecomeReady();
    }
}

