/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.server;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import org.newsclub.net.unix.demo.DemoHelper;
import org.newsclub.net.unix.demo.server.ChargenServer;
import org.newsclub.net.unix.demo.server.DemoServerBase;
import org.newsclub.net.unix.demo.server.EchoServer;
import org.newsclub.net.unix.demo.server.NullServer;
import org.newsclub.net.unix.demo.server.SendFileHandleServer;
import org.newsclub.net.unix.demo.server.ZeroServer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SocketServerDemo {
    public static void main(String[] args) throws IOException, InterruptedException {
        DemoServerBase demoServer;
        String demo = DemoHelper.getPropertyValue("demo", null, "echo, null, zero, chargen, send-fd");
        if (demo == null) {
            demoServer = null;
        } else {
            String socketName = DemoHelper.getPropertyValue("socket", "/tmp/junixsocket-" + demo + ".sock", "/tmp/test.sock or localhost:1234");
            SocketAddress listenAddress = DemoHelper.socketAddress(socketName);
            System.out.println("Listen address: " + listenAddress);
            switch (demo) {
                case "echo": {
                    demoServer = new EchoServer(listenAddress);
                    break;
                }
                case "null": {
                    demoServer = new NullServer(listenAddress);
                    break;
                }
                case "zero": {
                    demoServer = new ZeroServer(listenAddress);
                    break;
                }
                case "chargen": {
                    boolean fast = DemoHelper.getPropertyValue("fast", "true", "true/false", Boolean::valueOf);
                    demoServer = new ChargenServer(listenAddress, fast);
                    break;
                }
                case "send-fd": {
                    File file = DemoHelper.getPropertyValue("file", null, "path to file", File::new);
                    demoServer = new SendFileHandleServer(listenAddress, file);
                    break;
                }
                default: {
                    demoServer = null;
                }
            }
        }
        if (demoServer == null) {
            System.out.flush();
            System.err.println("You need to specify a valid demo to run.");
            return;
        }
        demoServer.setMaxConcurrentConnections(DemoHelper.getPropertyValue("maxConcurrentConnections", "10", "1", Integer::parseInt));
        demoServer.setServerTimeout(DemoHelper.getPropertyValue("serverTimeout", "0", "(time in ms)", Integer::parseInt));
        demoServer.setSocketTimeout(DemoHelper.getPropertyValue("socketTimeout", "60000", "(time in ms)", Integer::parseInt));
        demoServer.setServerBusyTimeout(DemoHelper.getPropertyValue("serverBusyTimeout", "1000", "(time in ms)", Integer::parseInt));
        demoServer.start();
    }
}

