/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.server;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.demo.server.DemoServerBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SendFileHandleServer
extends DemoServerBase {
    private final File file;

    public SendFileHandleServer(SocketAddress listenAddress, File file) {
        super(listenAddress);
        this.file = file;
    }

    protected void doServeSocket(Socket socket) throws IOException {
        if (!(socket instanceof AFUNIXSocket)) {
            throw new UnsupportedOperationException("File handles can only be sent via UNIX sockets");
        }
        this.doServeSocket((AFUNIXSocket)socket);
    }

    protected void doServeSocket(AFUNIXSocket socket) throws IOException {
        try (InputStream is = socket.getInputStream();
             OutputStream os = socket.getOutputStream();
             FileInputStream fin = new FileInputStream(this.file);){
            socket.setOutboundFileDescriptors(new FileDescriptor[]{fin.getFD()});
            os.write("FD sent via ancillary message.".getBytes("UTF-8"));
        }
    }
}

