/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import org.newsclub.net.unix.demo.client.DemoClientBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ReadWriteClient
extends DemoClientBase {
    @Override
    protected void handleSocket(Socket socket) throws IOException {
        try (final InputStream in = socket.getInputStream();
             final OutputStream out = socket.getOutputStream();){
            final byte[] readBuf = new byte[socket.getReceiveBufferSize()];
            final byte[] writeBuf = new byte[socket.getSendBufferSize()];
            final CountDownLatch cdl = new CountDownLatch(2);
            new Thread(this){
                final /* synthetic */ ReadWriteClient this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        int bytes;
                        while ((bytes = in.read(readBuf)) != -1) {
                            System.out.write(readBuf, 0, bytes);
                            System.out.flush();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    cdl.countDown();
                }
            }.start();
            new Thread(this){
                final /* synthetic */ ReadWriteClient this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        int bytes;
                        while ((bytes = System.in.read(writeBuf)) != -1) {
                            out.write(writeBuf, 0, bytes);
                            out.flush();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    cdl.countDown();
                }
            }.start();
            cdl.await();
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
    }
}

