/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.client;

import java.io.IOException;
import java.net.SocketAddress;
import org.newsclub.net.unix.demo.DemoHelper;
import org.newsclub.net.unix.demo.client.DemoClientBase;
import org.newsclub.net.unix.demo.client.ReadClient;
import org.newsclub.net.unix.demo.client.ReadFileHandleClient;
import org.newsclub.net.unix.demo.client.ReadWriteClient;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DemoClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException {
        DemoClientBase demoClient;
        String demo = DemoHelper.getPropertyValue("demo", "read-write", "read, read-write, read-fd");
        String socketName = DemoHelper.getPropertyValue("socket", "/tmp/junixsocket.sock", "/tmp/test.sock or localhost:1234");
        if (demo == null) {
            demoClient = null;
        } else {
            switch (demo) {
                case "read": {
                    demoClient = new ReadClient();
                    break;
                }
                case "read-write": {
                    demoClient = new ReadWriteClient();
                    break;
                }
                case "read-fd": {
                    demoClient = new ReadFileHandleClient();
                    break;
                }
                default: {
                    demoClient = null;
                }
            }
        }
        if (demoClient == null) {
            System.out.flush();
            System.err.println("You need to specify a valid demo to run.");
            return;
        }
        SocketAddress endpoint = DemoHelper.socketAddress(socketName);
        try {
            demoClient.connect(endpoint);
        }
        finally {
            demoClient.close();
        }
    }
}

