/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.mysql.demo;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.newsclub.net.mysql.AFUNIXDatabaseSocketFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXDatabaseSocketFactoryDemo {
    public static void main(String[] args) throws Exception {
        String driverClass = System.getProperty("mysqlDriver", "");
        if (driverClass.isEmpty()) {
            System.out.println("Using JDBC driver provided by SPI; override with -DmysqlDriver=com.mysql.jdbc.Driver");
        } else {
            System.out.println("Using JDBC driver provided by -DmysqlDriver=" + driverClass);
            Class.forName(driverClass);
        }
        System.out.println();
        Properties props = new Properties();
        AFUNIXDatabaseSocketFactoryDemo.addProperty(props, "socketFactory", AFUNIXDatabaseSocketFactory.class.getName(), null);
        AFUNIXDatabaseSocketFactoryDemo.addProperty(props, "junixsocket.file", "/tmp/mysql.sock", "mysqlSocket");
        AFUNIXDatabaseSocketFactoryDemo.addProperty(props, "user", "root", "mysqlUser");
        AFUNIXDatabaseSocketFactoryDemo.addProperty(props, "password", "", "mysqlPassword");
        System.out.println();
        Connection conn = DriverManager.getConnection("jdbc:mysql://", props);
        System.out.println("Connection: " + conn);
        String sql = "SHOW DATABASES";
        System.out.println(sql);
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                System.out.println("* " + rs.getString(1));
            }
        }
    }

    private static void addProperty(Properties props, String key, String value, String property) {
        if (property == null) {
            System.out.println(key + "=" + value);
        } else {
            value = System.getProperty(property, value);
            System.out.println(key + "=" + value + "; override with -D" + property);
        }
        props.setProperty(key, value);
    }
}

