/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class NativeLibraryLoader
implements Closeable {
    private static final String PROP_LIBRARY_OVERRIDE = "org.newsclub.net.unix.library.override";
    private static final String PROP_LIBRARY_LOADED = "org.newsclub.net.unix.library.loaded";
    private static final String PROP_LIBRARY_TMPDIR = "org.newsclub.net.unix.library.tmpdir";
    private static final File tempDir;
    private static final String architectureAndOS;
    private static boolean loaded;
    private String libraryName = "junixsocket-native";
    private String version;
    private String libraryNameAndVersion;
    private Class<?> providerClass;
    private String artifactName;
    private InputStream libraryIn;

    private void findLibraryArtifact() {
        try {
            if (!this.tryProviderClass("org.newsclub.lib.junixsocket.common.NarMetadata", "junixsocket-native-common") && !this.tryProviderClass("org.newsclub.lib.junixsocket.custom.NarMetadata", "junixsocket-native-custom")) {
                String cp = System.getProperty("java.class.path", "");
                if (cp.contains("junixsocket-native-custom/target-eclipse") || cp.contains("junixsocket-native-common/target-eclipse")) {
                    throw new UnsatisfiedLinkError("Could not load native library.\n\n*** ECLIPSE USERS ***\nIf you're running from within Eclipse, please close the \"junixsocket-native-*\" projects\n");
                }
                if (this.artifactName != null) {
                    throw new UnsatisfiedLinkError("Artifact " + this.artifactName + " does not contain library for " + architectureAndOS);
                }
                throw new ClassNotFoundException("You need to add a dependency to either junixsocket-native-common or junixsocket-native-custom");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean tryProviderClass(String providerClassname, String artifactCandidate) throws IOException {
        try {
            this.providerClass = Class.forName(providerClassname);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        this.artifactName = artifactCandidate;
        Properties p = new Properties();
        try (InputStream in = this.providerClass.getResourceAsStream("/META-INF/maven/com.kohlschutter.junixsocket/" + artifactCandidate + "/pom.properties");){
            p.load(in);
            this.version = p.getProperty("version");
            if (this.version == null) {
                throw new NullPointerException("Could not read version from pom.properties");
            }
            this.libraryNameAndVersion = this.libraryName + "-" + this.version;
        }
        this.libraryIn = this.findLibrary();
        return this.libraryIn != null;
    }

    private synchronized void setLoaded(String library) {
        loaded = true;
        System.setProperty(PROP_LIBRARY_LOADED, library);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadLibrary() {
        Class<Object> clazz = Object.class;
        synchronized (Object.class) {
            if (loaded || System.getProperty(PROP_LIBRARY_LOADED) != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            String libraryOverride = System.getProperty(PROP_LIBRARY_OVERRIDE, "");
            if (!libraryOverride.isEmpty()) {
                System.loadLibrary(libraryOverride);
                this.setLoaded(libraryOverride);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.findLibraryArtifact();
            try {
                System.loadLibrary(this.libraryNameAndVersion);
                this.setLoaded(this.artifactName + "/" + this.libraryNameAndVersion);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            catch (LinkageError e) {
                File libFile;
                if (this.libraryIn == null) {
                    throw e;
                }
                try {
                    libFile = NativeLibraryLoader.createTempFile("libtmp", System.mapLibraryName(this.libraryNameAndVersion));
                    try (FileOutputStream out = new FileOutputStream(libFile);){
                        int read;
                        byte[] buf = new byte[4096];
                        while ((read = this.libraryIn.read(buf)) >= 0) {
                            ((OutputStream)out).write(buf, 0, read);
                        }
                    }
                }
                catch (IOException e2) {
                    throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Couldn't load native library").initCause(e2);
                }
                System.load(libFile.getAbsolutePath());
                this.setLoaded(this.artifactName + "/" + this.libraryNameAndVersion);
                if (!libFile.delete()) {
                    libFile.deleteOnExit();
                }
                this.close();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
            return;
        }
    }

    private static String architectureAndOS() {
        return System.getProperty("os.arch") + "-" + System.getProperty("os.name").replaceAll(" ", "");
    }

    private InputStream findLibrary() {
        String mappedName = System.mapLibraryName(this.libraryNameAndVersion);
        for (String compiler : new String[]{"gpp", "g++", "linker", "gcc", "cc", "CC", "icpc", "icc", "xlC", "xlC_r", "msvc", "icl", "ecpc", "ecc"}) {
            String path = "/lib/" + architectureAndOS + "-" + compiler + "/jni/" + mappedName;
            InputStream in = this.providerClass.getResourceAsStream(path);
            if (in == null) continue;
            return in;
        }
        return null;
    }

    @Override
    public synchronized void close() {
        if (this.libraryIn != null) {
            try {
                this.libraryIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.libraryIn = null;
        }
    }

    private static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, tempDir);
    }

    static {
        architectureAndOS = NativeLibraryLoader.architectureAndOS();
        loaded = false;
        String dir = System.getProperty(PROP_LIBRARY_TMPDIR, null);
        tempDir = dir == null ? null : new File(dir);
    }
}

