/*
 * Decompiled with CFR 0.152.
 */
package com.klinker.android.link_builder;

import android.os.Handler;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.klinker.android.link_builder.TouchableBaseSpan;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/klinker/android/link_builder/TouchableMovementMethod;", "Landroid/text/method/LinkMovementMethod;", "()V", "<set-?>", "Lcom/klinker/android/link_builder/TouchableBaseSpan;", "pressedSpan", "getPressedSpan", "()Lcom/klinker/android/link_builder/TouchableBaseSpan;", "setPressedSpan", "(Lcom/klinker/android/link_builder/TouchableBaseSpan;)V", "widget", "Landroid/widget/TextView;", "spannable", "Landroid/text/Spannable;", "event", "Landroid/view/MotionEvent;", "onTouchEvent", "", "textView", "Companion", "library_release"})
public final class TouchableMovementMethod
extends LinkMovementMethod {
    @Nullable
    private TouchableBaseSpan pressedSpan;
    private static TouchableMovementMethod sInstance;
    private static boolean touched;
    public static final Companion Companion;

    @Nullable
    public final TouchableBaseSpan getPressedSpan() {
        return this.pressedSpan;
    }

    private final void setPressedSpan(TouchableBaseSpan touchableBaseSpan) {
        this.pressedSpan = touchableBaseSpan;
    }

    public boolean onTouchEvent(@NotNull TextView textView, @NotNull Spannable spannable, @NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
        Intrinsics.checkParameterIsNotNull((Object)spannable, (String)"spannable");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (event.getAction() == 0) {
            this.pressedSpan = this.getPressedSpan(textView, spannable, event);
            if (this.pressedSpan != null) {
                TouchableBaseSpan touchableBaseSpan = this.pressedSpan;
                if (touchableBaseSpan == null) {
                    Intrinsics.throwNpe();
                }
                touchableBaseSpan.setTouched(true);
                touched = true;
                new Handler().postDelayed(new Runnable(this, textView, spannable){
                    final /* synthetic */ TouchableMovementMethod this$0;
                    final /* synthetic */ TextView $textView;
                    final /* synthetic */ Spannable $spannable;

                    public final void run() {
                        if (TouchableMovementMethod.Companion.getTouched() && this.this$0.getPressedSpan() != null) {
                            if (this.$textView.isHapticFeedbackEnabled()) {
                                this.$textView.setHapticFeedbackEnabled(true);
                            }
                            this.$textView.performHapticFeedback(0);
                            TouchableBaseSpan touchableBaseSpan = this.this$0.getPressedSpan();
                            if (touchableBaseSpan == null) {
                                Intrinsics.throwNpe();
                            }
                            touchableBaseSpan.onLongClick((View)this.$textView);
                            TouchableBaseSpan touchableBaseSpan2 = this.this$0.getPressedSpan();
                            if (touchableBaseSpan2 == null) {
                                Intrinsics.throwNpe();
                            }
                            touchableBaseSpan2.setTouched(false);
                            TouchableMovementMethod.access$setPressedSpan$p(this.this$0, null);
                            Selection.removeSelection((Spannable)this.$spannable);
                        }
                    }
                    {
                        this.this$0 = touchableMovementMethod;
                        this.$textView = textView;
                        this.$spannable = spannable;
                    }
                }, 500L);
                Selection.setSelection((Spannable)spannable, (int)spannable.getSpanStart((Object)this.pressedSpan), (int)spannable.getSpanEnd((Object)this.pressedSpan));
            }
        } else if (event.getAction() == 2) {
            TouchableBaseSpan touchedSpan = this.getPressedSpan(textView, spannable, event);
            if (this.pressedSpan != null && Intrinsics.areEqual((Object)((Object)this.pressedSpan), (Object)((Object)touchedSpan)) ^ true) {
                TouchableBaseSpan touchableBaseSpan = this.pressedSpan;
                if (touchableBaseSpan == null) {
                    Intrinsics.throwNpe();
                }
                touchableBaseSpan.setTouched(false);
                this.pressedSpan = null;
                touched = false;
                Selection.removeSelection((Spannable)spannable);
            }
        } else if (event.getAction() == 1) {
            if (this.pressedSpan != null) {
                TouchableBaseSpan touchableBaseSpan = this.pressedSpan;
                if (touchableBaseSpan == null) {
                    Intrinsics.throwNpe();
                }
                touchableBaseSpan.onClick((View)textView);
                TouchableBaseSpan touchableBaseSpan2 = this.pressedSpan;
                if (touchableBaseSpan2 == null) {
                    Intrinsics.throwNpe();
                }
                touchableBaseSpan2.setTouched(false);
                this.pressedSpan = null;
                Selection.removeSelection((Spannable)spannable);
            }
        } else {
            if (this.pressedSpan != null) {
                TouchableBaseSpan touchableBaseSpan = this.pressedSpan;
                if (touchableBaseSpan == null) {
                    Intrinsics.throwNpe();
                }
                touchableBaseSpan.setTouched(false);
                touched = false;
                super.onTouchEvent(textView, spannable, event);
            }
            this.pressedSpan = null;
            Selection.removeSelection((Spannable)spannable);
        }
        return true;
    }

    private final TouchableBaseSpan getPressedSpan(TextView widget, Spannable spannable, MotionEvent event) {
        int n;
        int x = (int)event.getX();
        int y = (int)event.getY();
        x -= widget.getTotalPaddingLeft();
        y -= widget.getTotalPaddingTop();
        x += widget.getScrollX();
        Layout layout = widget.getLayout();
        int line = layout.getLineForVertical(y += widget.getScrollY());
        try {
            n = layout.getOffsetForHorizontal(line, (float)x);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        int off = n;
        int end = layout.getLineEnd(line);
        if (off != end && off != end - 1) {
            TouchableBaseSpan[] touchableBaseSpanArray;
            TouchableBaseSpan[] link = (TouchableBaseSpan[])spannable.getSpans(off, off, TouchableBaseSpan.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)link, (String)"link");
            TouchableBaseSpan[] touchableBaseSpanArray2 = touchableBaseSpanArray = link;
            if (!(touchableBaseSpanArray2.length == 0)) {
                return link[0];
            }
        }
        return null;
    }

    static {
        Companion = new Companion(null);
    }

    @Nullable
    public static final /* synthetic */ TouchableBaseSpan access$getPressedSpan$p(TouchableMovementMethod $this) {
        return $this.pressedSpan;
    }

    public static final /* synthetic */ void access$setPressedSpan$p(TouchableMovementMethod $this, @Nullable TouchableBaseSpan touchableBaseSpan) {
        $this.pressedSpan = touchableBaseSpan;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/klinker/android/link_builder/TouchableMovementMethod$Companion;", "", "()V", "instance", "Landroid/text/method/MovementMethod;", "getInstance", "()Landroid/text/method/MovementMethod;", "sInstance", "Lcom/klinker/android/link_builder/TouchableMovementMethod;", "touched", "", "getTouched", "()Z", "setTouched", "(Z)V", "library_release"})
    public static final class Companion {
        public final boolean getTouched() {
            return touched;
        }

        public final void setTouched(boolean bl) {
            touched = bl;
        }

        @NotNull
        public final MovementMethod getInstance() {
            if (sInstance == null) {
                sInstance = new TouchableMovementMethod();
            }
            TouchableMovementMethod touchableMovementMethod = sInstance;
            if (touchableMovementMethod == null) {
                Intrinsics.throwNpe();
            }
            return (MovementMethod)touchableMovementMethod;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

