/*
 * Decompiled with CFR 0.152.
 */
package com.klaxit.hiddensecrets;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J \u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\bJ\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/klaxit/hiddensecrets/Utils;", "", "()V", "encodeSecret", "", "key", "packageName", "findFileInProject", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "path", "fileName", "getCppName", "getKotlinFilePackage", "file", "sha256", "toHash", "HiddenSecretsPlugin"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE;

    @NotNull
    public final String getCppName(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)packageName, (String)"_", (String)"_1", (boolean)false, (int)4, null), (String)";", (String)"_2", (boolean)false, (int)4, null), (String)"[", (String)"_3", (boolean)false, (int)4, null), (String)".", (String)"_", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final String sha256(@NotNull String toHash) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)toHash, (String)"toHash");
        String string = toHash;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)digest, (String)"digest");
        byte[] byArray2 = digest;
        String initial$iv = "";
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        void var9_10 = $this$fold$iv;
        int n = ((void)var9_10).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv;
            void var13_14 = element$iv = var9_10[i];
            String str = accumulator$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder().append(str);
            String string2 = "%02x";
            Object[] objectArray = new Object[]{(byte)it};
            boolean bl3 = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
            accumulator$iv = stringBuilder.append(string3).toString();
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String encodeSecret(@NotNull String key, @NotNull String packageName) {
        void $this$forEach$iv;
        String obfuscator;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String string = obfuscator = this.sha256(packageName);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] obfuscatorBytes = byArray;
        boolean bl2 = false;
        ArrayList<Byte> obfuscatedSecretBytes = new ArrayList<Byte>();
        int i = 0;
        Object object = key;
        Charset charset2 = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"Charset.defaultCharset()");
        Charset charset3 = charset2;
        boolean bl3 = false;
        byte[] byArray2 = ((String)object).getBytes(charset3);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray2;
        boolean $i$f$forEach = false;
        void var9_14 = $this$forEach$iv;
        int n = ((void)var9_14).length;
        for (int j = 0; j < n; ++j) {
            void element$iv;
            void secretByte = element$iv = var9_14[j];
            boolean bl4 = false;
            byte obfuscatorByte = obfuscatorBytes[i % obfuscatorBytes.length];
            int n2 = secretByte;
            boolean bl5 = false;
            byte obfuscatedByte = (byte)(n2 ^ obfuscatorByte);
            obfuscatedSecretBytes.add(obfuscatedByte);
            n2 = i;
            i = n2 + 1;
        }
        String encoded = "{ ";
        Iterator iterator = obfuscatedSecretBytes.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"obfuscatedSecretBytes.iterator()");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            byte item = ((Number)iterator2.next()).byteValue();
            encoded = encoded + "0x" + Integer.toHexString(item & 0xFF);
            if (!iterator2.hasNext()) continue;
            encoded = encoded + ", ";
        }
        encoded = encoded + " }";
        return encoded;
    }

    @Nullable
    public final File findFileInProject(@NotNull Project project, @NotNull String path, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file = project.file((Object)path);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(path)");
        File directory = file;
        Sequence $this$forEach$iv = (Sequence)FilesKt.walkBottomUp((File)directory);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
            String string = fileName + " found in " + it.getAbsolutePath() + '\n';
            boolean bl2 = false;
            System.out.println((Object)string);
            return it;
        }
        String string = fileName + " not found in " + path;
        boolean bl = false;
        System.out.println((Object)string);
        return null;
    }

    @NotNull
    public final String getKotlinFilePackage(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.defaultCharset()");
        String text = (String)FilesKt.readLines((File)file, (Charset)charset).get(0);
        text = StringsKt.replace$default((String)text, (String)"package ", (String)"", (boolean)false, (int)4, null);
        text = StringsKt.replace$default((String)text, (String)"`", (String)"", (boolean)false, (int)4, null);
        String string = "Package : " + text + " found in " + file.getName();
        boolean bl = false;
        System.out.println((Object)string);
        return text;
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

