/*
 * Decompiled with CFR 0.152.
 */
package com.king.base.util;

import android.content.Context;

public class ResourcesUtils {
    private static final String RES_ID = "id";
    private static final String RES_STRING = "string";
    private static final String RES_DRAWABLE = "drawable";
    private static final String RES_LAYOUT = "layout";
    private static final String RES_STYLE = "style";
    private static final String RES_COLOR = "color";
    private static final String RES_DIMEN = "dimen";
    private static final String RES_ANIM = "anim";
    private static final String RES_MENU = "menu";

    private ResourcesUtils() {
        throw new AssertionError();
    }

    public static int getId(Context context, String resName) {
        return ResourcesUtils.getResId(context, resName, RES_ID);
    }

    public static int getStringId(Context context, String resName) {
        return ResourcesUtils.getResId(context, resName, RES_STRING);
    }

    public static int getDrawableId(Context context, String resName) {
        return ResourcesUtils.getResId(context, resName, RES_DRAWABLE);
    }

    public static int getLayoutId(Context context, String resName) {
        return ResourcesUtils.getResId(context, resName, RES_LAYOUT);
    }

    public static int getStyleId(Context context, String resName) {
        return ResourcesUtils.getResId(context, resName, RES_STYLE);
    }

    public static int getColorId(Context context, String resName) {
        return ResourcesUtils.getResId(context, resName, RES_COLOR);
    }

    public static int getDimenId(Context context, String resName) {
        return ResourcesUtils.getResId(context, resName, RES_DIMEN);
    }

    public static int getAnimId(Context context, String resName) {
        return ResourcesUtils.getResId(context, resName, RES_ANIM);
    }

    public static int getMenuId(Context context, String resName) {
        return ResourcesUtils.getResId(context, resName, RES_MENU);
    }

    public static int getResId(Context context, String resName, String defType) {
        return context.getResources().getIdentifier(resName, defType, context.getPackageName());
    }
}

