/*
 * Decompiled with CFR 0.152.
 */
package com.king.base.util;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import com.king.base.util.LogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;

public class SystemUtils {
    private SystemUtils() {
        throw new AssertionError();
    }

    public static void asyncThread(Runnable runnable) {
        new Thread(runnable).start();
    }

    public static boolean isNetWorkActive(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.isConnected();
    }

    public static void sendKeyCode(final int keyCode) {
        SystemUtils.asyncThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Instrumentation inst = new Instrumentation();
                    inst.sendKeyDownUpSync(keyCode);
                }
                catch (Exception e) {
                    LogUtils.e("Exception when sendPointerSync", e);
                }
            }
        });
    }

    public static void deleteClick(EditText et) {
        KeyEvent keyEventDown = new KeyEvent(0, 67);
        et.onKeyDown(67, keyEventDown);
    }

    public static void call(Context context, String phoneNumber) {
        Intent intent = new Intent("android.intent.action.DIAL", Uri.parse((String)String.format("tel:%s", phoneNumber)));
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void sendSMS(Context context, String phoneNumber) {
        Intent intent = new Intent("android.intent.action.SENDTO", Uri.parse((String)String.format("smsto:%s", phoneNumber)));
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void sendSMS(String phoneNumber, String msg) {
        SmsManager sm = SmsManager.getDefault();
        ArrayList msgs = sm.divideMessage(msg);
        for (String text : msgs) {
            sm.sendTextMessage(phoneNumber, null, text, null, null);
        }
    }

    public static void imageCapture(Activity activity, int requestCode) {
        SystemUtils.imageCapture(activity, null, requestCode);
    }

    public static void imageCapture(Activity activity, String path, int requestCode) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (!TextUtils.isEmpty((CharSequence)path)) {
            Uri uri = null;
            uri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)activity, (String)(activity.getPackageName() + ".fileProvider"), (File)new File(path)) : Uri.fromFile((File)new File(path));
            intent.putExtra("output", (Parcelable)uri);
        }
        activity.startActivityForResult(intent, requestCode);
    }

    public static void imageCapture(Fragment fragment, String path, int requestCode) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (!TextUtils.isEmpty((CharSequence)path)) {
            Uri uri = null;
            uri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)fragment.getContext(), (String)(fragment.getContext().getPackageName() + ".fileProvider"), (File)new File(path)) : Uri.fromFile((File)new File(path));
            intent.putExtra("output", (Parcelable)uri);
        }
        fragment.startActivityForResult(intent, requestCode);
    }

    public static PackageInfo getPackageInfo(Context context) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            LogUtils.e(e);
        }
        catch (Exception e) {
            LogUtils.e(e);
        }
        return packageInfo;
    }

    public static PackageInfo getPackageInfo(Context context, String archiveFilePath) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageArchiveInfo(archiveFilePath, 1);
            return packageInfo;
        }
        catch (Exception e) {
            LogUtils.e(e);
            return null;
        }
    }

    public static String getVersionName(Context context) {
        PackageInfo packageInfo = SystemUtils.getPackageInfo(context);
        return packageInfo != null ? packageInfo.versionName : null;
    }

    public static int getVersionCode(Context context) {
        PackageInfo packageInfo = SystemUtils.getPackageInfo(context);
        return packageInfo != null ? packageInfo.versionCode : 0;
    }

    public static void startAppDetailSetings(Context context) {
        Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", uri);
        context.startActivity(intent);
    }

    public static void installApk(Context context, String path) {
        SystemUtils.installApk(context, new File(path));
    }

    public static void installApk(Context context, File file) {
        SystemUtils.installApk(context, file, context.getPackageName() + ".fileProvider");
    }

    public static void installApk(Context context, File file, String authority) {
        Uri uriData;
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        intent.addCategory("android.intent.category.DEFAULT");
        String type = "application/vnd.android.package-archive";
        if (Build.VERSION.SDK_INT >= 24) {
            intent.addFlags(1);
            uriData = FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
        } else {
            uriData = Uri.fromFile((File)file);
        }
        intent.setDataAndType(uriData, type);
        context.startActivity(intent);
    }

    public static void uninstallApk(Context context, String packageName) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        Uri uriData = Uri.parse((String)("package:" + packageName));
        intent.setData(uriData);
        context.startActivity(intent);
    }

    public static void uninstallApk(Context context) {
        SystemUtils.uninstallApk(context, context.getPackageName());
    }

    public static boolean checkSelfPermission(Context context, @NonNull String permission2) {
        return ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
    }

    public static void requestPermission(Activity activity, @NonNull String permission2, int requestCode) {
        ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{permission2}, (int)requestCode);
    }

    public static void shouldShowRequestPermissionRationale(Activity activity, @NonNull String permission2) {
        ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2);
    }

    public static void hideInputMethod(Context context, EditText v) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
    }

    public static void showInputMethod(Context context, EditText v) {
        v.requestFocus();
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.showSoftInput((View)v, 1);
    }

    public static boolean apkExists(Context context, int versionCode, File file) {
        if (file != null && file.exists()) {
            ApplicationInfo applicationInfo;
            String packageName = context.getPackageName();
            PackageInfo packageInfo = SystemUtils.getPackageInfo(context, file.getAbsolutePath());
            if (packageInfo != null && versionCode == packageInfo.versionCode && (applicationInfo = packageInfo.applicationInfo) != null && packageName.equals(applicationInfo.packageName)) {
                return true;
            }
        }
        return false;
    }

    public static String getSystemLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public static Locale[] getSystemLanguageList() {
        return Locale.getAvailableLocales();
    }

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getSystemModel() {
        return Build.MODEL;
    }

    public static String getDeviceBrand() {
        return Build.BRAND;
    }

    public static String getIMEI(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (tm != null && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            if (Build.VERSION.SDK_INT >= 26) {
                return tm.getImei();
            }
            return tm.getDeviceId();
        }
        return "";
    }
}

