/*
 * Decompiled with CFR 0.152.
 */
package com.king.base.util;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.annotation.RequiresApi;

public class UriUtils {
    public static String getPath(Context context, Uri uri) {
        int sdkVersion = Build.VERSION.SDK_INT;
        if (sdkVersion >= 19) {
            return UriUtils.getRealPathFromUriAboveApi19(context, uri);
        }
        return UriUtils.getRealPathFromUriBelowAPI19(context, uri);
    }

    private static String getRealPathFromUriBelowAPI19(Context context, Uri uri) {
        return UriUtils.getDataColumn(context, uri, null, null);
    }

    @RequiresApi(api=19)
    private static String getRealPathFromUriAboveApi19(Context context, Uri uri) {
        String filePath = null;
        if (DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            String documentId = DocumentsContract.getDocumentId((Uri)uri);
            if (UriUtils.isMediaDocument(uri)) {
                String id = documentId.split(":")[1];
                String selection = "_id=?";
                String[] selectionArgs = new String[]{id};
                filePath = UriUtils.getDataColumn(context, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, selection, selectionArgs);
            } else if (UriUtils.isDownloadsDocument(uri)) {
                Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(documentId));
                filePath = UriUtils.getDataColumn(context, contentUri, null, null);
            }
        } else if ("content".equalsIgnoreCase(uri.getScheme())) {
            filePath = UriUtils.getDataColumn(context, uri, null, null);
        } else if ("file".equals(uri.getScheme())) {
            filePath = uri.getPath();
        }
        return filePath;
    }

    private static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        String path;
        block3: {
            path = null;
            String[] projection = new String[]{"_data"};
            Cursor cursor = null;
            try {
                cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
                if (cursor != null && cursor.moveToFirst()) {
                    int columnIndex = cursor.getColumnIndexOrThrow(projection[0]);
                    path = cursor.getString(columnIndex);
                }
            }
            catch (Exception e) {
                if (cursor == null) break block3;
                cursor.close();
            }
        }
        return path;
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }
}

