/*
 * Decompiled with CFR 0.152.
 */
package com.king.base.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.util.Map;
import java.util.Set;

public class SharedPreferencesUtils {
    public static final String PREF_NAME = "Jenly";

    private SharedPreferencesUtils() {
        throw new AssertionError();
    }

    public static SharedPreferences getSharedPreferences(Context context) {
        return SharedPreferencesUtils.getSharedPreferences(context, PREF_NAME);
    }

    public static SharedPreferences getSharedPreferences(Context context, String prefName) {
        return context.getSharedPreferences(prefName, 0);
    }

    public static void put(Context context, String key, int value) {
        SharedPreferencesUtils.getSharedPreferences(context).edit().putInt(key, value).commit();
    }

    public static int getInt(Context context, String key, int defValue) {
        return SharedPreferencesUtils.getSharedPreferences(context).getInt(key, defValue);
    }

    public static int getInt(Context context, String key) {
        return SharedPreferencesUtils.getInt(context, key, 0);
    }

    public static void put(Context context, String key, float value) {
        SharedPreferencesUtils.getSharedPreferences(context).edit().putFloat(key, value).commit();
    }

    public static float getFloat(Context context, String key, float defValue) {
        return SharedPreferencesUtils.getSharedPreferences(context).getFloat(key, defValue);
    }

    public static float getFloat(Context context, String key) {
        return SharedPreferencesUtils.getFloat(context, key, 0.0f);
    }

    public static void put(Context context, String key, long value) {
        SharedPreferencesUtils.getSharedPreferences(context).edit().putLong(key, value).commit();
    }

    public static long getLong(Context context, String key, long defValue) {
        return SharedPreferencesUtils.getSharedPreferences(context).getLong(key, defValue);
    }

    public static long getLong(Context context, String key) {
        return SharedPreferencesUtils.getLong(context, key, 0L);
    }

    public static void put(Context context, String key, boolean value) {
        SharedPreferencesUtils.getSharedPreferences(context).edit().putBoolean(key, value).commit();
    }

    public static boolean getBoolean(Context context, String key, boolean defValue) {
        return SharedPreferencesUtils.getSharedPreferences(context).getBoolean(key, defValue);
    }

    public static boolean getBoolean(Context context, String key) {
        return SharedPreferencesUtils.getBoolean(context, key, false);
    }

    public static void put(Context context, String key, String value) {
        SharedPreferencesUtils.getSharedPreferences(context).edit().putString(key, value).commit();
    }

    public static String getString(Context context, String key, String defValue) {
        return SharedPreferencesUtils.getSharedPreferences(context).getString(key, defValue);
    }

    public static String getString(Context context, String key) {
        return SharedPreferencesUtils.getString(context, key, null);
    }

    @TargetApi(value=11)
    public static void put(Context context, String key, Set<String> value) {
        SharedPreferencesUtils.getSharedPreferences(context).edit().putStringSet(key, value).commit();
    }

    @TargetApi(value=11)
    public static Set<String> getStringSet(Context context, String key, Set<String> defValue) {
        return SharedPreferencesUtils.getSharedPreferences(context).getStringSet(key, defValue);
    }

    public static Set<String> getStringSet(Context context, String key) {
        return SharedPreferencesUtils.getStringSet(context, key, null);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static void putMapString(Context context, Map<String, String> map) {
        if (map != null) {
            SharedPreferences.Editor editor = SharedPreferencesUtils.getSharedPreferences(context).edit();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (TextUtils.isEmpty((CharSequence)entry.getKey())) continue;
                editor.putString(entry.getKey(), entry.getValue());
            }
            editor.commit();
        }
    }

    public static void increase(Context context, String key) {
        SharedPreferencesUtils.increase(context, key, 1);
    }

    public static void increase(Context context, String key, int deltaValue) {
        SharedPreferencesUtils.put(context, key, SharedPreferencesUtils.getInt(context, key) + deltaValue);
    }
}

