/*
 * Decompiled with CFR 0.152.
 */
package com.king.base.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class ImageUtils {
    private ImageUtils() {
        throw new AssertionError();
    }

    public static byte[] bitmapToByte(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)o);
        return o.toByteArray();
    }

    public static Bitmap byteToBitmap(byte[] b) {
        return b == null || b.length == 0 ? null : BitmapFactory.decodeByteArray((byte[])b, (int)0, (int)b.length);
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        return drawable == null ? null : ((BitmapDrawable)drawable).getBitmap();
    }

    public static Drawable bitmapToDrawable(Bitmap bitmap) {
        return bitmap == null ? null : new BitmapDrawable(bitmap);
    }

    public static byte[] drawableToByte(Drawable d) {
        return ImageUtils.bitmapToByte(ImageUtils.drawableToBitmap(d));
    }

    public static Drawable byteToDrawable(byte[] b) {
        return ImageUtils.bitmapToDrawable(ImageUtils.byteToBitmap(b));
    }

    public static Bitmap scaleImageTo(Bitmap bitmap, int newWidth, int newHeight) {
        return ImageUtils.scaleImage(bitmap, (float)newWidth / (float)bitmap.getWidth(), (float)newHeight / (float)bitmap.getHeight());
    }

    public static Bitmap scaleImage(Bitmap bitmap, float scaleWidth, float scaleHeight) {
        if (bitmap == null) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }
}

