/*
 * Decompiled with CFR 0.152.
 */
package com.khipu;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.khipu.ApiException;
import java.io.IOException;
import java.text.DateFormat;
import javax.ws.rs.core.GenericType;

public class JSON {
    private ObjectMapper mapper = new ObjectMapper();

    public JSON() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        this.mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
    }

    public String serialize(Object obj) throws ApiException {
        try {
            if (obj != null) {
                return this.mapper.writeValueAsString(obj);
            }
            return null;
        }
        catch (Exception e) {
            throw new ApiException(400, e.getMessage());
        }
    }

    public String serializeCanonical(Object obj) throws ApiException {
        try {
            if (obj != null) {
                Object tmpObject = this.mapper.readValue(this.mapper.writeValueAsString(obj), Object.class);
                return this.mapper.writeValueAsString(tmpObject);
            }
            return null;
        }
        catch (Exception e) {
            throw new ApiException(400, e.getMessage());
        }
    }

    public JSON setDateFormat(DateFormat dateFormat) {
        this.mapper.setDateFormat(dateFormat);
        return this;
    }

    public <T> T deserialize(String body, GenericType<T> returnType) throws ApiException {
        JavaType javaType = this.mapper.constructType(returnType.getType());
        try {
            return (T)this.mapper.readValue(body, javaType);
        }
        catch (IOException e) {
            if (returnType.getType().equals(String.class)) {
                return (T)body;
            }
            throw new ApiException(500, e.getMessage(), null, body);
        }
    }
}

