/*
 * Decompiled with CFR 0.152.
 */
package com.justai.aimybox.speechkit.google.cloud;

import android.content.Context;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.cloud.texttospeech.v1.AudioConfig;
import com.google.cloud.texttospeech.v1.AudioEncoding;
import com.google.cloud.texttospeech.v1.SynthesisInput;
import com.google.cloud.texttospeech.v1.SynthesizeSpeechResponse;
import com.google.cloud.texttospeech.v1.TextToSpeechClient;
import com.google.cloud.texttospeech.v1.TextToSpeechSettings;
import com.google.cloud.texttospeech.v1.VoiceSelectionParams;
import com.justai.aimybox.media.AudioSynthesizer;
import com.justai.aimybox.model.AudioSpeech;
import com.justai.aimybox.model.TextSpeech;
import com.justai.aimybox.speechkit.google.cloud.GoogleCloudCredentials;
import com.justai.aimybox.speechkit.google.cloud.model.Gender;
import com.justai.aimybox.texttospeech.BaseTextToSpeech;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u000eH\u0002J\u0019\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Lcom/justai/aimybox/speechkit/google/cloud/GoogleCloudTextToSpeech;", "Lcom/justai/aimybox/texttospeech/BaseTextToSpeech;", "context", "Landroid/content/Context;", "credentials", "Lcom/justai/aimybox/speechkit/google/cloud/GoogleCloudCredentials;", "locale", "Ljava/util/Locale;", "config", "Lcom/justai/aimybox/speechkit/google/cloud/GoogleCloudTextToSpeech$Config;", "(Landroid/content/Context;Lcom/justai/aimybox/speechkit/google/cloud/GoogleCloudCredentials;Ljava/util/Locale;Lcom/justai/aimybox/speechkit/google/cloud/GoogleCloudTextToSpeech$Config;)V", "client", "Lcom/google/cloud/texttospeech/v1/TextToSpeechClient;", "createAuthorizedClient", "Lcom/google/auth/Credentials;", "speak", "", "speech", "Lcom/justai/aimybox/model/TextSpeech;", "(Lcom/justai/aimybox/model/TextSpeech;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Config", "google-cloud-speechkit_release"})
public final class GoogleCloudTextToSpeech
extends BaseTextToSpeech {
    private final TextToSpeechClient client;
    private final Locale locale;
    private final Config config;

    @Nullable
    public Object speak(@NotNull TextSpeech speech, @NotNull Continuation<? super Unit> $completion) {
        SynthesisInput input = SynthesisInput.newBuilder().setText(speech.getText()).build();
        VoiceSelectionParams.Builder builder = VoiceSelectionParams.newBuilder();
        String string = speech.getLanguage();
        if (string == null) {
            string = this.locale.getLanguage();
        }
        VoiceSelectionParams voice = builder.setLanguageCode(string).setSsmlGender(this.config.getGender().getValue$google_cloud_speechkit_release()).setName(this.config.getVoice()).build();
        AudioConfig audioConfig = AudioConfig.newBuilder().setAudioEncoding(AudioEncoding.MP3).setSpeakingRate(this.config.getSpeakingRate()).setPitch(this.config.getPitch()).build();
        SynthesizeSpeechResponse response = this.client.synthesizeSpeech(input, voice, audioConfig);
        AudioSynthesizer audioSynthesizer = this.getAudioSynthesizer();
        SynthesizeSpeechResponse synthesizeSpeechResponse = response;
        Intrinsics.checkExpressionValueIsNotNull((Object)synthesizeSpeechResponse, (String)"response");
        byte[] byArray = synthesizeSpeechResponse.getAudioContent().toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"response.audioContent.toByteArray()");
        return audioSynthesizer.play((AudioSpeech)new AudioSpeech.Bytes(byArray), $completion);
    }

    private final TextToSpeechClient createAuthorizedClient(Credentials credentials) {
        TextToSpeechSettings settings = ((TextToSpeechSettings.Builder)TextToSpeechSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials))).build();
        TextToSpeechClient textToSpeechClient = TextToSpeechClient.create((TextToSpeechSettings)settings);
        Intrinsics.checkExpressionValueIsNotNull((Object)textToSpeechClient, (String)"TextToSpeechClient.create(settings)");
        return textToSpeechClient;
    }

    public GoogleCloudTextToSpeech(@NotNull Context context, @NotNull GoogleCloudCredentials credentials, @NotNull Locale locale, @NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(context);
        this.locale = locale;
        this.config = config;
        this.client = this.createAuthorizedClient(credentials.getCredentials$google_cloud_speechkit_release());
    }

    public /* synthetic */ GoogleCloudTextToSpeech(Context context, GoogleCloudCredentials googleCloudCredentials, Locale locale, Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            config = new Config(null, null, 0.0, 0.0, 15, null);
        }
        this(context, googleCloudCredentials, locale, config);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/justai/aimybox/speechkit/google/cloud/GoogleCloudTextToSpeech$Config;", "", "gender", "Lcom/justai/aimybox/speechkit/google/cloud/model/Gender;", "voice", "", "speakingRate", "", "pitch", "(Lcom/justai/aimybox/speechkit/google/cloud/model/Gender;Ljava/lang/String;DD)V", "getGender", "()Lcom/justai/aimybox/speechkit/google/cloud/model/Gender;", "getPitch", "()D", "getSpeakingRate", "getVoice", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "google-cloud-speechkit_release"})
    public static final class Config {
        @NotNull
        private final Gender gender;
        @NotNull
        private final String voice;
        private final double speakingRate;
        private final double pitch;

        @NotNull
        public final Gender getGender() {
            return this.gender;
        }

        @NotNull
        public final String getVoice() {
            return this.voice;
        }

        public final double getSpeakingRate() {
            return this.speakingRate;
        }

        public final double getPitch() {
            return this.pitch;
        }

        public Config(@NotNull Gender gender, @NotNull String voice, double speakingRate, double pitch) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)gender), (String)"gender");
            Intrinsics.checkParameterIsNotNull((Object)voice, (String)"voice");
            this.gender = gender;
            this.voice = voice;
            this.speakingRate = speakingRate;
            this.pitch = pitch;
        }

        public /* synthetic */ Config(Gender gender, String string, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                gender = Gender.NEUTRAL;
            }
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                d = 0.0;
            }
            if ((n & 8) != 0) {
                d2 = 0.0;
            }
            this(gender, string, d, d2);
        }

        public Config() {
            this(null, null, 0.0, 0.0, 15, null);
        }

        @NotNull
        public final Gender component1() {
            return this.gender;
        }

        @NotNull
        public final String component2() {
            return this.voice;
        }

        public final double component3() {
            return this.speakingRate;
        }

        public final double component4() {
            return this.pitch;
        }

        @NotNull
        public final Config copy(@NotNull Gender gender, @NotNull String voice, double speakingRate, double pitch) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)gender), (String)"gender");
            Intrinsics.checkParameterIsNotNull((Object)voice, (String)"voice");
            return new Config(gender, voice, speakingRate, pitch);
        }

        public static /* synthetic */ Config copy$default(Config config, Gender gender, String string, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                gender = config.gender;
            }
            if ((n & 2) != 0) {
                string = config.voice;
            }
            if ((n & 4) != 0) {
                d = config.speakingRate;
            }
            if ((n & 8) != 0) {
                d2 = config.pitch;
            }
            return config.copy(gender, string, d, d2);
        }

        @NotNull
        public String toString() {
            return "Config(gender=" + (Object)((Object)this.gender) + ", voice=" + this.voice + ", speakingRate=" + this.speakingRate + ", pitch=" + this.pitch + ")";
        }

        public int hashCode() {
            Gender gender = this.gender;
            String string = this.voice;
            long l = Double.doubleToLongBits(this.speakingRate);
            long l2 = Double.doubleToLongBits(this.pitch);
            return (((gender != null ? ((Object)((Object)gender)).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (int)(l ^ l >>> 32)) * 31 + (int)(l2 ^ l2 >>> 32);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Config)) break block3;
                    Config config = (Config)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.gender), (Object)((Object)config.gender)) || !Intrinsics.areEqual((Object)this.voice, (Object)config.voice) || Double.compare(this.speakingRate, config.speakingRate) != 0 || Double.compare(this.pitch, config.pitch) != 0) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

