/*
 * Decompiled with CFR 0.152.
 */
package com.justadeveloper96.notificationcreator;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.justadeveloper96.notificationcreator.Action;
import com.justadeveloper96.notificationcreator.ICreator;
import com.justadeveloper96.notificationcreator.NotificationData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 A2\u00020\u0001:\u0001AB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H'J\u0016\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0004H&J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J.\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\"\u001a\u0004\u0018\u00010\u001d2\b\u0010#\u001a\u0004\u0018\u00010\u0004H\u0002J\u0015\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010&J\u0017\u0010'\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u0012H'\u00a2\u0006\u0002\u0010(J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010+\u001a\u0004\u0018\u00010!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010.\u001a\u0004\u0018\u00010!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010/\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0010\u00102\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0017\u00103\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u0012H'\u00a2\u0006\u0002\u0010(J\u001a\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0010\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u00108\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0019\u00109\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\u0018\u0010:\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\u0015H\u0016J\u0010\u0010<\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010=\u001a\u0004\u0018\u0001012\u0006\u0010>\u001a\u00020\u0004H&J \u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010;\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006B"}, d2={"Lcom/justadeveloper96/notificationcreator/GenericCreator;", "Lcom/justadeveloper96/notificationcreator/ICreator;", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "actionDrawableMap", "", "type", "activityMap", "Ljava/lang/Class;", "key", "beforeNotification", "", "context", "Landroid/content/Context;", "data", "Lcom/justadeveloper96/notificationcreator/NotificationData;", "buildNotification", "notificationBuilder", "Landroidx/core/app/NotificationCompat$Builder;", "createBuilder", "service", "Landroid/app/NotificationManager;", "extractActions", "", "Lcom/justadeveloper96/notificationcreator/Action;", "extractExtras", "Landroid/os/Bundle;", "getActions", "Landroidx/core/app/NotificationCompat$Action;", "getActionsPendingIntent", "Landroid/app/PendingIntent;", "bundle", "action", "getAutoCancel", "", "(Lcom/justadeveloper96/notificationcreator/NotificationData;)Ljava/lang/Boolean;", "getColor", "(Lcom/justadeveloper96/notificationcreator/NotificationData;)Ljava/lang/Integer;", "getContentIntent", "Landroid/content/Intent;", "getContentPendingIntent", "getContentText", "getContentTitle", "getDeleteIntent", "getGroupKey", "getLargeIcon", "Landroid/graphics/Bitmap;", "getSendNotificationId", "getSmallIcon", "getSound", "Landroid/net/Uri;", "getStyle", "Landroidx/core/app/NotificationCompat$Style;", "initService", "invoke", "modifyBuilder", "builder", "preModifyData", "provideBitmap", "imgUrl", "sendNotification", "id", "Companion", "notificationcreator_release"})
public abstract class GenericCreator
implements ICreator {
    @NotNull
    private final String TAG = "GenericCreator";
    public static final Companion Companion = new Companion(null);

    private final NotificationManager initService(Context context) {
        Object object = context.getSystemService("notification");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        return (NotificationManager)object;
    }

    @Override
    public void invoke(@NotNull Context context, @NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        NotificationManager service = this.initService(context);
        NotificationData data2 = this.preModifyData(data);
        NotificationCompat.Builder builder = this.createBuilder(context, data2, service);
        this.beforeNotification(context, data2);
        this.buildNotification(data2, builder, context);
        this.modifyBuilder(data2, builder);
        this.sendNotification(this.getSendNotificationId(data2), service, builder);
    }

    public void beforeNotification(@NotNull Context context, @NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
    }

    @NotNull
    public NotificationData preModifyData(@NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return data;
    }

    public void modifyBuilder(@NotNull NotificationData data, @NotNull NotificationCompat.Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
    }

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Intent getContentIntent(@NotNull Context context, @NotNull NotificationData data) {
        Intent intent;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (data.getAction() != null) {
            Intent intent2 = new Intent(data.getAction());
            Object object = this.extractExtras(data);
            if (object != null && (object = object.getString("data")) != null) {
                Object object2;
                Object object3 = object2 = object;
                intent2.setData(Uri.parse((String)object3));
            }
            intent = intent2;
            return intent;
        }
        if (data.getLandingId() != null) {
            String string = data.getLandingId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (this.activityMap(string) != null) {
                String string2 = data.getLandingId();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                Intent intent3 = new Intent(context, this.activityMap(string2));
                Bundle bundle = this.extractExtras(data);
                if (bundle != null) {
                    Bundle bundle2;
                    Bundle bundle3 = bundle2 = bundle;
                    intent3.putExtras(bundle3);
                }
                intent = intent3;
                return intent;
            }
        }
        try {
            throw (Throwable)new Exception("Landing action/id not available");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public final Bundle extractExtras(@NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return data.getBundle();
    }

    private final PendingIntent getContentPendingIntent(Context context, NotificationData data) {
        Intent intent = this.getContentIntent(context, data);
        return intent == null ? null : PendingIntent.getActivity((Context)context, (int)new Random().nextInt(), (Intent)intent, (int)0x8000000);
    }

    private final PendingIntent getActionsPendingIntent(Context context, NotificationData data, Bundle bundle, String action) {
        PendingIntent pendingIntent;
        Intent intent = this.getContentIntent(context, data);
        if (intent == null) {
            pendingIntent = null;
        } else {
            intent.setAction(action);
            Bundle bundle2 = bundle;
            if (bundle2 != null) {
                Bundle bundle3;
                Bundle it = bundle3 = bundle2;
                intent.putExtras(it);
            }
            pendingIntent = PendingIntent.getActivity((Context)context, (int)new Random().nextInt(), (Intent)intent, (int)0x8000000);
        }
        return pendingIntent;
    }

    private final NotificationCompat.Builder createBuilder(Context context, NotificationData data, NotificationManager service) {
        NotificationCompat.Builder builder;
        String imp = data.getChannelPriority();
        if (Build.VERSION.SDK_INT >= 26) {
            String name = data.getChannelName();
            String id = data.getChannelId();
            NotificationChannel channel = new NotificationChannel(id, (CharSequence)name, Companion.getChannelImportance(imp));
            service.createNotificationChannel(channel);
            builder = new NotificationCompat.Builder(context, channel.getId());
        } else {
            builder = new NotificationCompat.Builder(context);
        }
        NotificationCompat.Builder builder2 = builder;
        builder2.setPriority(Companion.getNotificationImportance(data.getChannelPriority()));
        return builder2;
    }

    public void sendNotification(int id, @NotNull NotificationManager service, @NotNull NotificationCompat.Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        service.notify(id, builder.build());
    }

    public int getSendNotificationId(@NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return new Random().nextInt();
    }

    private final void buildNotification(NotificationData data, NotificationCompat.Builder notificationBuilder, Context context) {
        block13: {
            Object object;
            if (Build.VERSION.SDK_INT >= 21) {
                Integer n = this.getColor(data);
                if (n != null) {
                    object = n;
                    int it = ((Number)object).intValue();
                    notificationBuilder.setColor(ContextCompat.getColor((Context)context, (int)it));
                }
            }
            notificationBuilder.setLights(-65536, 1000, 300);
            Uri uri = this.getSound(data, context);
            if (uri != null) {
                object = uri;
                Integer it = object;
                notificationBuilder.setSound((Uri)it);
            }
            PendingIntent pendingIntent = this.getContentPendingIntent(context, data);
            if (pendingIntent != null) {
                object = pendingIntent;
                Integer it = object;
                notificationBuilder.setContentIntent((PendingIntent)it);
            }
            String string = this.getContentTitle(data);
            if (string != null) {
                Object it = object = string;
                notificationBuilder.setContentTitle((CharSequence)it);
            }
            String string2 = this.getContentText(data);
            if (string2 != null) {
                Object it = object = string2;
                notificationBuilder.setContentText((CharSequence)it);
            }
            Boolean bl = this.getAutoCancel(data);
            if (bl != null) {
                object = bl;
                boolean it = (Boolean)object;
                notificationBuilder.setAutoCancel(it);
            }
            notificationBuilder.setDefaults(2);
            Integer n = this.getSmallIcon(data);
            if (n != null) {
                object = n;
                int it = ((Number)object).intValue();
                notificationBuilder.setSmallIcon(it);
            }
            NotificationCompat.Style style = this.getStyle(data);
            if (style != null) {
                Object it = object = style;
                notificationBuilder.setStyle((NotificationCompat.Style)it);
            }
            Bitmap bitmap = this.getLargeIcon(context, data);
            if (bitmap != null) {
                Object it = object = bitmap;
                notificationBuilder.setLargeIcon((Bitmap)it);
            }
            String string3 = this.getGroupKey(data);
            if (string3 != null) {
                Object it = object = string3;
                notificationBuilder.setGroup((String)it);
            }
            List<NotificationCompat.Action> list = this.getActions(context, data);
            if (list != null) {
                Iterable $receiver$iv = list;
                for (Object element$iv : $receiver$iv) {
                    NotificationCompat.Action it = (NotificationCompat.Action)element$iv;
                    notificationBuilder.addAction(it);
                }
            }
            PendingIntent pendingIntent2 = this.getDeleteIntent(context, data);
            if (pendingIntent2 == null) break block13;
            Object it = object = pendingIntent2;
            notificationBuilder.setDeleteIntent((PendingIntent)it);
        }
    }

    @Nullable
    public abstract Uri getSound(@NotNull NotificationData var1, @NotNull Context var2);

    @ColorRes
    @Nullable
    public abstract Integer getColor(@NotNull NotificationData var1);

    private final String getContentText(NotificationData data) {
        String string;
        String it;
        CharSequence charSequence;
        String string2 = data.getMessage();
        return string2 != null ? (!StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)(it = (string = string2)))) ? string : null) : null;
    }

    private final String getContentTitle(NotificationData data) {
        String string;
        String it;
        CharSequence charSequence;
        String string2 = data.getTitle();
        return string2 != null ? (!StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)(it = (string = string2)))) ? string : null) : null;
    }

    @Nullable
    public final Boolean getAutoCancel(@NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return true;
    }

    @Nullable
    public List<NotificationCompat.Action> getActions(@NotNull Context context, @NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        List list = new ArrayList();
        List<Action> list2 = this.extractActions(data);
        if (list2 != null) {
            Iterable $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                Action it = (Action)element$iv;
                NotificationCompat.Action action = new NotificationCompat.Action.Builder(this.actionDrawableMap(it.getDrawable()), (CharSequence)it.getLabel(), this.getActionsPendingIntent(context, data, it.getBundle(), it.getAction())).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)action, (String)"NotificationCompat.Actio\u2026undle,it.action)).build()");
                list.add(action);
            }
        }
        return list;
    }

    @DrawableRes
    public abstract int actionDrawableMap(@NotNull String var1);

    @Nullable
    public final List<Action> extractActions(@NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return data.getActions();
    }

    @Nullable
    public final String getGroupKey(@NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return null;
    }

    @Nullable
    public abstract Bitmap getLargeIcon(@NotNull Context var1, @NotNull NotificationData var2);

    @Nullable
    public final NotificationCompat.Style getStyle(@NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = data.getStyle();
        if (string != null) {
            switch (string) {
                case "message": {
                    return (NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)this.getContentText(data));
                }
                case "bigPicture": {
                    Map<String, String> map = data.getExtras();
                    if (map != null && (map = map.get("bigPicture")) != null) {
                        Map<String, String> map2;
                        Map<String, String> it = map2 = map;
                        Bitmap bitmap = this.provideBitmap((String)((Object)it));
                        if (bitmap != null) {
                            Bitmap bitmap2;
                            Bitmap it2 = bitmap2 = bitmap;
                            return (NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(it2);
                        }
                        return null;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    @Nullable
    public abstract Bitmap provideBitmap(@NotNull String var1);

    @Nullable
    public PendingIntent getDeleteIntent(@NotNull Context context, @NotNull NotificationData data) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return null;
    }

    @DrawableRes
    @Nullable
    public abstract Integer getSmallIcon(@NotNull NotificationData var1);

    @Nullable
    public abstract Class<?> activityMap(@NotNull String var1);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/justadeveloper96/notificationcreator/GenericCreator$Companion;", "", "()V", "getChannelImportance", "", "importance", "", "getNotificationImportance", "notificationcreator_release"})
    public static final class Companion {
        public final int getChannelImportance(@NotNull String importance) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)importance, (String)"importance");
            switch (importance) {
                case "max": {
                    n = 5;
                    break;
                }
                case "high": {
                    n = 4;
                    break;
                }
                case "low": {
                    n = 2;
                    break;
                }
                case "min": {
                    n = 1;
                    break;
                }
                default: {
                    n = 3;
                }
            }
            return n;
        }

        public final int getNotificationImportance(@NotNull String importance) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)importance, (String)"importance");
            switch (importance) {
                case "max": {
                    n = 2;
                    break;
                }
                case "high": {
                    n = 1;
                    break;
                }
                case "low": {
                    n = -1;
                    break;
                }
                case "min": {
                    n = -2;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

