/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.content.Context;
import android.view.SurfaceView;
import com.juphoon.cloud.JCLog;
import com.juphoon.cloud.JCParam;
import com.juphoon.cloud.ZmfEngine;

public class JCMediaDeviceVideoCanvas {
    static final String TAG = JCMediaDeviceVideoCanvas.class.getSimpleName();
    boolean autoRotate = false;
    private String mVideoSource;
    private SurfaceView mSurfaceView;
    private int mRenderType;

    JCMediaDeviceVideoCanvas(Context context, String videoSource, int renderType) {
        this.mVideoSource = videoSource;
        this.mSurfaceView = ZmfEngine.getInstance().createView();
        this.mRenderType = renderType;
    }

    public SurfaceView getVideoView() {
        return this.mSurfaceView;
    }

    void switchCamera(String camera) {
        String oldVideoSource = this.mVideoSource;
        this.mVideoSource = camera;
        JCParam.RenderDeal param = new JCParam.RenderDeal();
        param.type = 2;
        param.view = this.mSurfaceView;
        param.videoSource = this.mVideoSource;
        param.oldVideoSource = oldVideoSource;
        ZmfEngine.getInstance().dealRender(param);
    }

    public void pause() {
        JCParam.RenderDeal param = new JCParam.RenderDeal();
        param.type = 1;
        param.view = this.mSurfaceView;
        if (!ZmfEngine.getInstance().dealRender((JCParam.RenderDeal)param).succ) {
            JCLog.error(TAG, "\u6e32\u67d3\u505c\u6b62\u5931\u8d25", new Object[0]);
        }
    }

    public void resume() {
        JCParam.RenderDeal param = new JCParam.RenderDeal();
        param.type = 0;
        param.videoSource = this.mVideoSource;
        param.view = this.mSurfaceView;
        param.autoRotate = this.autoRotate;
        param.renderType = this.translateRenderTypeToMtc();
        if (!ZmfEngine.getInstance().dealRender((JCParam.RenderDeal)param).succ) {
            JCLog.error(TAG, "\u6e32\u67d3\u5931\u8d25", new Object[0]);
        }
    }

    public void rotate(int angle) {
        JCParam.RenderDeal param = new JCParam.RenderDeal();
        param.type = 3;
        param.view = this.mSurfaceView;
        param.angle = angle;
        ZmfEngine.getInstance().dealRender(param);
    }

    public boolean snapshot(int width, int height, String filePath) {
        JCParam.Snapshot param = new JCParam.Snapshot();
        param.videoSource = this.mVideoSource;
        param.width = width;
        param.height = height;
        param.filePath = filePath;
        if (ZmfEngine.getInstance().videoSnapshot((JCParam.Snapshot)param).succ) {
            return true;
        }
        JCLog.error(TAG, "\u622a\u5c4f\u5931\u8d25", new Object[0]);
        return false;
    }

    public String getVideoSource() {
        return this.mVideoSource;
    }

    private int translateRenderTypeToMtc() {
        switch (this.mRenderType) {
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        return -1;
    }
}

