package com.juphoon.cloud;

import android.os.Handler;
import android.os.Looper;

/**
 * @author juphoon
 */
class JCClientThreadImpl implements JCClientThread {

    public static JCClientThread getInstance() {
        return MainThreadHolder.INSTANCE;
    }

    private Handler mHandler;


    private JCClientThreadImpl() {
        mHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void post(Runnable runnable) {
        mHandler.post(runnable);
    }

    @Override
    public void postDelayed(Runnable runnable, long delayMillis) {
        mHandler.postDelayed(runnable, delayMillis);
    }

    @Override
    public void removeRunnable(Runnable runnable) {
        mHandler.removeCallbacks(runnable);
    }

    private static final class MainThreadHolder {
        private static final JCClientThread INSTANCE = new JCClientThreadImpl();
    }
}
