/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.media.AudioManager;
import android.os.Build;
import android.text.TextUtils;
import com.juphoon.cloud.JCClient;
import com.juphoon.cloud.JCClientCallback;
import com.juphoon.cloud.JCClientThreadImpl;
import com.juphoon.cloud.JCLog;
import com.juphoon.cloud.JCMediaDevice;
import com.juphoon.cloud.JCMediaDeviceCallback;
import com.juphoon.cloud.JCMediaDeviceVideoCanvas;
import com.juphoon.cloud.JCNotify;
import com.juphoon.cloud.JCParam;
import com.juphoon.cloud.ZmfEngine;
import com.justalk.cloud.lemon.MtcCallDb;
import com.justalk.cloud.lemon.MtcNumber;
import com.justalk.cloud.zmf.ZmfVideo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

class JCMediaDeviceImpl
extends JCMediaDevice
implements JCClientCallback,
ZmfEngine.ZmfNotifyListener {
    static final String TAG = JCMediaDeviceImpl.class.getSimpleName();
    private List<JCMediaDeviceCallback> mCallbacks = new ArrayList<JCMediaDeviceCallback>();
    private JCClient mClient;
    private int mDefaultCameraIndex;
    private int mCameraIndex;
    private boolean mCameraOpen;
    private boolean mVideoFileOpen;
    private String mVideoFileId;
    private boolean mAudioStart;
    private boolean mSpeakerOn;
    private int mWidth;
    private int mHeight;
    private int mFramerate;
    private int mScreenCaptureWidth;
    private int mScreenCaptureHeight;
    private int mScreenCaptureFrameRate;
    private List<JCMediaDeviceVideoCanvas> mCameraCanvas = new ArrayList<JCMediaDeviceVideoCanvas>();
    private List<JCMediaDeviceVideoCanvas> mVideoFileCanvas = new ArrayList<JCMediaDeviceVideoCanvas>();
    private List<JCMediaDeviceVideoCanvas> mOtherCanvas = new ArrayList<JCMediaDeviceVideoCanvas>();
    private List<String> mCameras;
    private AudioManager mAudioManager;
    private boolean mSawtooth;
    private int mAecMode;
    private int mVideoMode;
    private ByteBuffer mVideoFileFrameBuffer;
    private boolean mAgcOn;

    JCMediaDeviceImpl(JCClient client, JCMediaDeviceCallback callback) {
        JCParam.Init param = new JCParam.Init();
        param.context = client.getContext();
        ZmfEngine.getInstance().initialize(param);
        this.mCameraOpen = false;
        this.mVideoFileOpen = false;
        this.mAudioStart = false;
        this.mSpeakerOn = false;
        this.mSawtooth = false;
        this.mAecMode = 2;
        this.mVideoMode = 0;
        this.mWidth = 352;
        this.mHeight = 282;
        this.mFramerate = 10;
        this.mScreenCaptureWidth = 640;
        this.mScreenCaptureHeight = 360;
        this.mScreenCaptureFrameRate = 10;
        this.mCameras = ZmfEngine.getInstance().getCameras();
        if (this.mCameras.size() > 0) {
            this.mCameraIndex = 0;
            this.mDefaultCameraIndex = 0;
        } else {
            this.mCameraIndex = -1;
            this.mDefaultCameraIndex = -1;
        }
        this.mVideoFileId = "6e946949562a5cee94987c91ae53162b";
        this.mClient = client;
        this.mCallbacks.add(callback);
        this.mClient.addCallback(this);
        ZmfEngine.getInstance().addZmfNotifyListener(this);
        this.mAudioManager = (AudioManager)this.mClient.getContext().getSystemService("audio");
        this.mAgcOn = false;
    }

    @Override
    protected void destroyObj() {
        this.mCameras.clear();
        this.mCallbacks.clear();
        this.mClient.removeCallback(this);
        this.mClient = null;
        ZmfEngine.getInstance().removeZmfNotifyListener(this);
        ZmfEngine.getInstance().uninitialize();
    }

    @Override
    public boolean isCameraOpen() {
        return this.mCameraOpen;
    }

    @Override
    public boolean isSpeakerOn() {
        return this.mSpeakerOn;
    }

    @Override
    public String getCamera() {
        if (this.mCameraIndex >= 0 && this.mCameraIndex < this.mCameras.size()) {
            return this.mCameras.get(this.mCameraIndex);
        }
        return null;
    }

    @Override
    public List<String> getCameras() {
        return this.mCameras;
    }

    @Override
    public JCMediaDeviceVideoCanvas startCameraVideo(int renderType) {
        if (this.mCameras.size() == 0) {
            return null;
        }
        JCMediaDeviceVideoCanvas canvas = new JCMediaDeviceVideoCanvas(this.mClient.getContext(), this.mCameras.get(this.mCameraIndex), renderType);
        canvas.autoRotate = this.autoRotate;
        canvas.resume();
        this.mCameraCanvas.add(canvas);
        this.startCamera();
        return canvas;
    }

    @Override
    public JCMediaDeviceVideoCanvas startVideo(String videoSource, int renderType) {
        JCMediaDeviceVideoCanvas canvas = new JCMediaDeviceVideoCanvas(this.mClient.getContext(), videoSource, renderType);
        canvas.autoRotate = this.autoRotate;
        canvas.resume();
        if (TextUtils.equals((CharSequence)videoSource, (CharSequence)this.mVideoFileId)) {
            this.startVideoFile();
            this.mVideoFileCanvas.add(canvas);
        } else {
            this.mOtherCanvas.add(canvas);
        }
        return canvas;
    }

    @Override
    public void stopVideo(JCMediaDeviceVideoCanvas canvas) {
        canvas.pause();
        if (this.mCameraCanvas.contains(canvas)) {
            this.mCameraCanvas.remove(canvas);
            if (this.mCameraCanvas.size() == 0) {
                JCLog.info(TAG, "No local video object", new Object[0]);
                this.stopCamera();
            }
        } else if (this.mVideoFileCanvas.contains(canvas)) {
            this.mVideoFileCanvas.remove(canvas);
            if (this.mVideoFileCanvas.size() == 0) {
                JCLog.info(TAG, "No file video object", new Object[0]);
                this.stopVideoFile();
            }
        } else {
            this.mOtherCanvas.remove(canvas);
        }
    }

    @Override
    public boolean startAudio() {
        if (this.mAudioStart) {
            JCLog.info(TAG, "Audio is turned on", new Object[0]);
        } else {
            JCParam.AudioDeal param = new JCParam.AudioDeal();
            param.start = true;
            param.watch = this.mVideoMode == 0 || this.mVideoMode == 1;
            param.os = this.mAecMode != 1;
            param.agc = this.mAgcOn;
            if (ZmfEngine.getInstance().dealAudio((JCParam.AudioDeal)param).succ) {
                JCLog.info(TAG, "Turn on the audio", new Object[0]);
            } else {
                JCLog.info(TAG, "Turn on the audio fail", new Object[0]);
            }
            this.mAudioManager.setMode(this.getAudioMode());
            this.mAudioStart = true;
        }
        return this.mAudioStart;
    }

    @Override
    public boolean stopAudio() {
        if (this.mAudioStart) {
            JCParam.AudioDeal param = new JCParam.AudioDeal();
            param.start = false;
            if (ZmfEngine.getInstance().dealAudio((JCParam.AudioDeal)param).succ) {
                JCLog.info(TAG, "Turn off audio", new Object[0]);
            } else {
                JCLog.info(TAG, "Turn off audio fail", new Object[0]);
            }
            this.mAudioManager.setMode(0);
            this.mAudioStart = false;
        } else {
            JCLog.info(TAG, "Audio has been turned off", new Object[0]);
        }
        return !this.mAudioStart;
    }

    @Override
    public boolean startCamera() {
        if (this.mCameraOpen) {
            JCLog.info(TAG, "Camera is on", new Object[0]);
            return true;
        }
        this.stopVideoFile();
        this.mCameraIndex = this.mDefaultCameraIndex;
        JCParam.CameraDeal param = new JCParam.CameraDeal();
        param.type = 0;
        param.camera = this.mCameras.get(this.mCameraIndex);
        param.width = this.mWidth;
        param.height = this.mHeight;
        param.framerate = this.mFramerate;
        if (ZmfEngine.getInstance().dealCamera((JCParam.CameraDeal)param).succ) {
            JCLog.info(TAG, "Camera open", new Object[0]);
            this.mCameraOpen = true;
            this.notifyCameraUpdate();
            return true;
        }
        JCLog.error(TAG, "Camera failed to open", new Object[0]);
        return false;
    }

    @Override
    public boolean stopCamera() {
        if (this.mCameraOpen) {
            JCParam.CameraDeal param = new JCParam.CameraDeal();
            param.type = 1;
            param.camera = this.mCameras.get(this.mCameraIndex);
            if (ZmfEngine.getInstance().dealCamera((JCParam.CameraDeal)param).succ) {
                JCLog.info(TAG, "Camera off", new Object[0]);
            } else {
                JCLog.error(TAG, "Camera failed", new Object[0]);
            }
            this.mCameraOpen = false;
            this.mCameraIndex = this.mDefaultCameraIndex;
            this.notifyCameraUpdate();
        } else {
            JCLog.info(TAG, "Camera is off", new Object[0]);
        }
        return true;
    }

    @Override
    public boolean switchCamera() {
        if (this.mCameraOpen) {
            JCParam.CameraDeal param = new JCParam.CameraDeal();
            param.type = 2;
            param.switchedCamera = this.mCameras.get(this.mCameraIndex);
            this.mCameraIndex = (this.mCameraIndex + 1) % this.mCameras.size();
            param.camera = this.mCameras.get(this.mCameraIndex);
            if (this.mCameras.size() == 0) {
                return false;
            }
            if (this.mCameras.size() == 1) {
                JCLog.info(TAG, "Only one camera", new Object[0]);
                return true;
            }
            param.width = this.mWidth;
            param.height = this.mHeight;
            param.framerate = this.mFramerate;
            if (ZmfEngine.getInstance().dealCamera((JCParam.CameraDeal)param).succ) {
                for (JCMediaDeviceVideoCanvas canvas : this.mCameraCanvas) {
                    canvas.switchCamera(param.camera);
                }
                this.notifyCameraUpdate();
                return true;
            }
            JCLog.error(TAG, "Switching camera failed", new Object[0]);
        } else {
            JCLog.error(TAG, "Switching camera is not turned on", new Object[0]);
        }
        return false;
    }

    @Override
    public void specifyCamera(int cameraIndex) {
        if (cameraIndex >= 0 && cameraIndex < this.mCameras.size()) {
            this.mDefaultCameraIndex = cameraIndex;
        }
    }

    @Override
    public void setCameraProperty(int width, int height, int frameRate) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFramerate = frameRate;
    }

    @Override
    public void setScreenCaptureProperty(int width, int height, int frameRate) {
        this.mScreenCaptureWidth = width;
        this.mScreenCaptureHeight = height;
        this.mScreenCaptureFrameRate = frameRate;
    }

    @Override
    public int getCameraType(int cameraIndex) {
        if (cameraIndex >= 0 && cameraIndex < this.mCameras.size()) {
            if (this.mCameras.get(cameraIndex).equals(ZmfVideo.CaptureFront())) {
                return 1;
            }
            if (this.mCameras.get(cameraIndex).equals(ZmfVideo.CaptureBack())) {
                return 2;
            }
            return 3;
        }
        return 0;
    }

    @Override
    public void enableSpeaker(boolean enable) {
        if (this.mSpeakerOn != enable) {
            this.mSpeakerOn = enable;
            this.mAudioManager.setSpeakerphoneOn(this.mSpeakerOn);
            this.notifyAudioOutputTypeChange();
        }
    }

    @Override
    public void setVideoMode(int videoMode, JCMediaDevice.VideoModeOtherParam otherParam) {
        JCLog.info(TAG, "setVideoMode %d", videoMode);
        this.mVideoMode = videoMode;
        if (this.mVideoMode == 0) {
            this.mWidth = 352;
            this.mHeight = 288;
            this.mFramerate = 10;
        } else if (this.mVideoMode == 1) {
            this.mWidth = 352;
            this.mHeight = 288;
            this.mFramerate = 10;
        } else {
            this.mWidth = 640;
            this.mHeight = 480;
            this.mFramerate = this.mVideoMode == 3 ? 30 : 10;
        }
        this.configMeidaParam(otherParam);
    }

    @Override
    public int getVideoMode() {
        return this.mVideoMode;
    }

    @Override
    public void setAecMode(int aecMode) {
        this.mAecMode = aecMode;
    }

    @Override
    public int getAecMode() {
        return this.mAecMode;
    }

    @Override
    public void setSawtooth(boolean sawtooth) {
        this.mSawtooth = sawtooth;
    }

    @Override
    public boolean isVideoFileOpen() {
        return this.mVideoFileOpen;
    }

    @Override
    public String getVideoFileId() {
        return this.mVideoFileId;
    }

    @Override
    public boolean startVideoFile() {
        if (this.mVideoFileOpen) {
            JCLog.info(TAG, "Video file capture is turned on", new Object[0]);
            return true;
        }
        this.stopCamera();
        this.mVideoFileOpen = true;
        this.notifyCameraUpdate();
        return true;
    }

    @Override
    public void setVideoFileFrame(byte[] data, int format, int width, int height, int angle, int mirror, boolean keyFrame) {
        int[] nArray;
        int fixAngle;
        if (!this.mVideoFileOpen) {
            JCLog.error(TAG, "Video file capture is not open", new Object[0]);
            return;
        }
        int[] cfg = null;
        int n = fixAngle = width >= height ? 0 : 90;
        if (format == 100) {
            cfg = new int[11];
            cfg[0] = data.length;
            cfg[3] = 1;
            int n2 = cfg[5] = keyFrame ? 1 : 0;
            if (this.mVideoFileFrameBuffer == null || this.mVideoFileFrameBuffer.array().length < data.length) {
                this.mVideoFileFrameBuffer = ByteBuffer.allocateDirect(data.length).order(ByteOrder.nativeOrder());
            }
            this.mVideoFileFrameBuffer.position(0);
            this.mVideoFileFrameBuffer.put(data);
        } else {
            ByteBuffer srcFrame = ByteBuffer.allocateDirect(data.length).order(ByteOrder.nativeOrder());
            srcFrame.position(0);
            srcFrame.put(data);
            int imgSize = width * height;
            int frameSize = imgSize * 4;
            if (this.mVideoFileFrameBuffer == null || this.mVideoFileFrameBuffer.array().length < frameSize) {
                this.mVideoFileFrameBuffer = ByteBuffer.allocateDirect(frameSize).order(ByteOrder.nativeOrder());
            }
            ZmfVideo.convertToI420((ByteBuffer)this.mVideoFileFrameBuffer, (int)format, (ByteBuffer)srcFrame, (int)width, (int)height, (int)fixAngle, (int[])new int[]{width, height});
        }
        if (fixAngle == 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = width;
            nArray = nArray2;
            nArray2[1] = height;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = height;
            nArray = nArray3;
            nArray3[1] = width;
        }
        ZmfVideo.onVideoCapture((String)this.mVideoFileId, (int)mirror, (int)(angle + 360 - fixAngle), (int)(angle + 360 - fixAngle), (int[])nArray, (ByteBuffer)this.mVideoFileFrameBuffer, (String)(format == 100 ? "H264" : null), (int[])cfg);
    }

    @Override
    public boolean stopVideoFile() {
        if (!this.mVideoFileOpen) {
            JCLog.info(TAG, "Video file capture is off", new Object[0]);
            return true;
        }
        JCParam.CameraDeal param = new JCParam.CameraDeal();
        param.type = 1;
        param.camera = this.mVideoFileId;
        ZmfEngine.getInstance().dealCamera(param);
        this.mVideoFileOpen = false;
        this.mVideoFileFrameBuffer = null;
        this.notifyCameraUpdate();
        return true;
    }

    @Override
    public void readyForH264() {
        this.startVideoFile();
        byte[] buf = new byte[10];
        buf[0] = 5;
        this.setVideoFileFrame(buf, 100, 1, 1, 0, 0, false);
        this.stopVideoFile();
    }

    @Override
    protected void addCallback(JCMediaDeviceCallback callback) {
        this.mCallbacks.add(callback);
    }

    @Override
    protected void removeCallback(JCMediaDeviceCallback callback) {
        this.mCallbacks.remove(callback);
    }

    @Override
    protected void configMeidaParam(JCMediaDevice.VideoModeOtherParam otherParam) {
        JCLog.info(TAG, "configMeidaParam videoMode=%d", this.mVideoMode);
        MtcCallDb.Mtc_CallDbSetAnUsePresetVideoParams((boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"PCMU", (boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"G722", (boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"AMR-WB", (boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"PCMA", (boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"iLBC", (boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"opus", (boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"AMR", (boolean)true);
        MtcCallDb.Mtc_CallDbSetAudioCodecEnable((String)"G729", (boolean)false);
        MtcCallDb.Mtc_CallDbSetAudioCodecByPriority((String)"AMR", (short)0);
        MtcCallDb.Mtc_CallDbSetVideoCodecEnable((String)"VP8", (boolean)true);
        MtcCallDb.Mtc_CallDbSetArsEnable((boolean)true);
        MtcCallDb.Mtc_CallDbSetVoiceArsParam((int)12000, (int)2000);
        MtcCallDb.Mtc_CallDbSetVadEnable((boolean)true);
        MtcCallDb.Mtc_CallDbSetAudioRed((boolean)false);
        MtcCallDb.Mtc_CallDbSetRxAnrEnable((boolean)false);
        MtcNumber Aec = new MtcNumber();
        MtcNumber Anr = new MtcNumber();
        MtcNumber Agc = new MtcNumber();
        MtcNumber Vad = new MtcNumber();
        MtcCallDb.Mtc_CallDbGetAudioQos((MtcNumber)Aec, (MtcNumber)Anr, (MtcNumber)Agc, (MtcNumber)Vad);
        boolean bAec = false;
        boolean bAgc = false;
        boolean bVad = false;
        if (Aec.getValue() != 0) {
            bAec = true;
        }
        if (Agc.getValue() != 0) {
            bAgc = true;
        }
        if (Vad.getValue() != 0) {
            bVad = true;
        }
        MtcCallDb.Mtc_CallDbSetAudioRtxEnable((boolean)false);
        MtcCallDb.Mtc_CallDbSetSrtpCryptoType((int)0);
        MtcCallDb.Mtc_CallDbSetAecMode((short)(this.mAecMode == 0 ? (short)1 : 4));
        MtcCallDb.Mtc_CallDbSetResolutionControl((boolean)false);
        MtcCallDb.Mtc_CallDbSetVideoArs((boolean)true);
        MtcCallDb.Mtc_CallDbSetSmallNaluEnable((boolean)true);
        MtcCallDb.Mtc_CallDbSetVideoRedFec((boolean)false);
        MtcCallDb.Mtc_CallDbSetVideoFramerate((int)this.mFramerate);
        if (this.mVideoMode == 0 || this.mVideoMode == 1) {
            if (this.mSawtooth) {
                MtcCallDb.Mtc_CallDbSetAnVideoRecvResolution((int)240, (int)240);
            } else {
                MtcCallDb.Mtc_CallDbSetAnVideoRecvResolution((int)176, (int)144);
            }
            if (this.mVideoMode == 0) {
                MtcCallDb.Mtc_CallDbSetVideoArsParm((int)80000, (int)10000, (int)0, (int)0);
                MtcCallDb.Mtc_CallDbSetVideoArsFixBitrate((int)50);
            } else {
                MtcCallDb.Mtc_CallDbSetVideoArsParm((int)200000, (int)10000, (int)0, (int)0);
                MtcCallDb.Mtc_CallDbSetVideoArsFixBitrate((int)150);
            }
            if (this.mVideoMode == 0) {
                this.mAgcOn = false;
                MtcCallDb.Mtc_CallDbSetAudioQos((boolean)bAec, (boolean)false, (boolean)false, (boolean)true);
            } else {
                this.mAgcOn = true;
                MtcCallDb.Mtc_CallDbSetAudioQos((boolean)bAec, (boolean)false, (boolean)true, (boolean)true);
            }
        } else if (this.mVideoMode == 2) {
            this.mAgcOn = false;
            MtcCallDb.Mtc_CallDbSetAudioQos((boolean)bAec, (boolean)false, (boolean)false, (boolean)true);
            MtcCallDb.Mtc_CallDbSetAnVideoRecvResolution((int)352, (int)288);
            if (this.mFramerate >= 15 || this.mSawtooth) {
                MtcCallDb.Mtc_CallDbSetVideoArsParm((int)120000, (int)10000, (int)0, (int)0);
            } else {
                MtcCallDb.Mtc_CallDbSetVideoArsParm((int)80000, (int)10000, (int)0, (int)0);
            }
            MtcCallDb.Mtc_CallDbSetVideoArsFixBitrate((int)50);
        } else {
            MtcCallDb.Mtc_CallDbSetAnVideoRecvResolution((int)640, (int)360);
            MtcCallDb.Mtc_CallDbSetAudioQos((boolean)bAec, (boolean)false, (boolean)true, (boolean)true);
            MtcCallDb.Mtc_CallDbSetAnUsePresetVideoParams((boolean)true);
            MtcCallDb.Mtc_CallDbSetVoiceArsParam((int)75000, (int)20000);
            MtcCallDb.Mtc_CallDbSetVideoArsParm((int)1500000, (int)50000, (int)0, (int)0);
            MtcCallDb.Mtc_CallDbSetVideoArsFixBitrate((int)800);
        }
        if (otherParam != null && otherParam.agc != -1) {
            this.mAgcOn = true;
            MtcCallDb.Mtc_CallDbSetAudioQos((boolean)bAec, (boolean)false, (otherParam.agc > 0 ? 1 : 0) != 0, (boolean)true);
        }
    }

    @Override
    public void onLogin(boolean result, int reason) {
    }

    @Override
    public void onLogout(int reason) {
    }

    @Override
    public void onClientStateChange(int state, int oldState) {
    }

    private void notifyCameraUpdate() {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "Camera change", new Object[0]);
                for (JCMediaDeviceCallback callback : JCMediaDeviceImpl.this.mCallbacks) {
                    callback.onCameraUpdate();
                }
            }
        });
    }

    private void notifyAudioOutputTypeChange() {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCLog.info(TAG, "Speaker change", new Object[0]);
                for (JCMediaDeviceCallback callback : JCMediaDeviceImpl.this.mCallbacks) {
                    callback.onAudioOutputTypeChange(JCMediaDeviceImpl.this.mSpeakerOn);
                }
            }
        });
    }

    private void notifyRenderReceived(final String renderId) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCMediaDeviceVideoCanvas canvas = JCMediaDeviceImpl.this.getCanvasByRenderId(renderId);
                if (canvas == null) {
                    JCLog.error(TAG, "Render object not found", new Object[0]);
                    return;
                }
                JCLog.info(TAG, "Received rendering data " + renderId, new Object[0]);
                for (JCMediaDeviceCallback callback : JCMediaDeviceImpl.this.mCallbacks) {
                    callback.onRenderReceived(canvas);
                }
            }
        });
    }

    private void notifyRenderStart(final String renderId) {
        JCClientThreadImpl.getInstance().post(new Runnable(){

            @Override
            public void run() {
                JCMediaDeviceVideoCanvas canvas = JCMediaDeviceImpl.this.getCanvasByRenderId(renderId);
                if (canvas == null) {
                    JCLog.error(TAG, "Render object not found", new Object[0]);
                    return;
                }
                JCLog.info(TAG, "Start of rendering", new Object[0]);
                for (JCMediaDeviceCallback callback : JCMediaDeviceImpl.this.mCallbacks) {
                    callback.onRenderStart(canvas);
                }
            }
        });
    }

    private int getAudioMode() {
        if (Build.VERSION.SDK_INT < 11) {
            return 0;
        }
        return 3;
    }

    @Override
    protected boolean enableScreenCapture(boolean enable) {
        JCParam.CameraDeal param = new JCParam.CameraDeal();
        if (enable) {
            param.type = 0;
            param.camera = ZmfVideo.CaptureScreen;
            param.width = this.mScreenCaptureWidth;
            param.height = this.mScreenCaptureHeight;
            param.framerate = this.mScreenCaptureFrameRate;
            if (ZmfEngine.getInstance().dealCamera((JCParam.CameraDeal)param).succ) {
                JCLog.info(TAG, "Screen sharing Capture is successfully turned on", new Object[0]);
                return true;
            }
            JCLog.error(TAG, "Screen sharing Capture failed to open", new Object[0]);
            return false;
        }
        param.type = 1;
        param.camera = ZmfVideo.CaptureScreen;
        if (ZmfEngine.getInstance().dealCamera((JCParam.CameraDeal)param).succ) {
            JCLog.info(TAG, "Screen sharing Capture closed successfully", new Object[0]);
            return true;
        }
        JCLog.error(TAG, "Screen sharing Capture close failed", new Object[0]);
        return false;
    }

    private JCMediaDeviceVideoCanvas getCanvasByRenderId(String renderId) {
        for (JCMediaDeviceVideoCanvas c : this.mCameraCanvas) {
            if (!TextUtils.equals((CharSequence)c.getVideoSource(), (CharSequence)renderId)) continue;
            return c;
        }
        for (JCMediaDeviceVideoCanvas c : this.mOtherCanvas) {
            if (!TextUtils.equals((CharSequence)c.getVideoSource(), (CharSequence)renderId)) continue;
            return c;
        }
        return null;
    }

    @Override
    public void onZmfNotify(JCNotify notify) {
        if (notify.type == 9) {
            JCNotify.Media mediaNotify = notify.mediaNotify;
            if (mediaNotify.type == 1) {
                this.notifyRenderReceived(mediaNotify.renderReceived.renderId);
            } else if (mediaNotify.type == 2) {
                this.notifyRenderStart(mediaNotify.renderStart.renderId);
            }
        }
    }
}

