/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.graphics.Point;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import com.justalk.cloud.zmf.Zmf;
import com.justalk.cloud.zmf.ZmfActivity;
import com.justalk.cloud.zmf.ZmfVideo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ScreenCapture
extends OrientationEventListener {
    private static MediaProjection sMediaProjection;
    private VirtualDisplay mVirtualDisplay;
    private ImageReader mImageReader;
    private Display mDisplay;
    private int mRotation = 0;
    private int mScreenOrient = 0;
    private int mRotateAngle = 0;
    private Boolean mStarted;
    private Boolean mIsStarting;
    private Handler mHandler;
    private static final int VIRTUAL_DISPLAY_FLAGS = 17;
    private int mWidth;
    private int mHeight;
    private int mFps;
    private long mLastTimeMs;
    private int mDurationMs;
    ByteBuffer _bufI420;
    byte[] _midBuf;
    ByteBuffer _tempBuf;
    int _format;
    private int _enableRotate = 1;
    Context _appCxt;
    private ContentObserver _observer = null;
    private static int screenNum;

    ScreenCapture(Context context) {
        super(context);
        this._appCxt = context;
        this.mStarted = false;
        this.mIsStarting = false;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.mDisplay = windowManager.getDefaultDisplay();
        ZmfVideo.CaptureScreen = "Screen_Capture_0";
        ++screenNum;
    }

    public int createScreenCapture(MediaProjection mediaProjection) {
        if (mediaProjection == null) {
            this.mIsStarting = false;
            ZmfVideo.onErrorOccurred("Screen:user denied");
            return -1;
        }
        if (sMediaProjection != null) {
            this.stop();
        }
        sMediaProjection = mediaProjection;
        ZmfVideo.logInfo("create screen capture");
        if (this.mIsStarting.booleanValue()) {
            this.mIsStarting = false;
            this.start(this.mWidth, this.mHeight, this.mFps);
        }
        return 0;
    }

    @SuppressLint(value={"NewApi"})
    public int destroyScreenCapture() {
        this.stop();
        if (sMediaProjection != null) {
            sMediaProjection.stop();
            sMediaProjection = null;
            ZmfVideo.logInfo("destroy screen capture");
        }
        return 0;
    }

    private void onAccelerometerRotationChange() {
        try {
            this._enableRotate = Settings.System.getInt((ContentResolver)this._appCxt.getContentResolver(), (String)"accelerometer_rotation");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            this._enableRotate = 1;
            settingNotFoundException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public void onOrientationChanged(int n) {
        ScreenCapture screenCapture = this;
        synchronized (screenCapture) {
            try {
                int n2;
                if (this._enableRotate != 0 && n >= 0) {
                    boolean bl = true;
                    if (this.mScreenOrient == 0 && (n >= 300 || n <= 60)) {
                        bl = false;
                    } else if (n >= this.mScreenOrient - 60 && n <= this.mScreenOrient + 60) {
                        bl = false;
                    }
                    if (bl) {
                        n2 = n / 45;
                        int n3 = n2 % 2;
                        this.mScreenOrient = (n2 + n3) * 45 % 360;
                    }
                }
                this.mRotation = this.mDisplay.getRotation();
                if (this._enableRotate != 0) {
                    this.mRotateAngle = (this.mRotation * 90 + this.mScreenOrient) % 360;
                }
                Point point = new Point();
                this.mDisplay.getSize(point);
                if (point.x > point.y && this.mWidth < this.mHeight || point.x < point.y && this.mWidth > this.mHeight) {
                    n2 = this.mWidth;
                    this.mWidth = this.mHeight;
                    this.mHeight = n2;
                    if (this.mVirtualDisplay != null) {
                        this.mVirtualDisplay.setSurface(null);
                        this.mVirtualDisplay.resize(this.mWidth, this.mHeight, 240);
                        if (this.mImageReader != null) {
                            this.mImageReader.setOnImageAvailableListener(null, null);
                            this.mImageReader = ImageReader.newInstance((int)this.mWidth, (int)this.mHeight, (int)1, (int)2);
                            this.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)new ImageAvailableListener(), this.mHandler);
                            this.mVirtualDisplay.setSurface(this.mImageReader.getSurface());
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    public int start(int n, int n2, int n3) {
        if (this.mStarted.booleanValue()) {
            ZmfVideo.logInfo("screen capture already started.");
            return 0;
        }
        if (n3 <= 0) {
            n3 = 4;
        } else if (n3 > 30) {
            n3 = 30;
        }
        this.mFps = n3;
        this.mLastTimeMs = SystemClock.elapsedRealtime();
        this.mDurationMs = 1000 / this.mFps;
        if (sMediaProjection != null) {
            this.mIsStarting = false;
            this.enable();
            this.onAccelerometerRotationChange();
            this._observer = new ContentObserver(Zmf._handler){

                public void onChange(boolean bl) {
                    ScreenCapture.this.onAccelerometerRotationChange();
                }
            };
            Uri uri = Settings.System.getUriFor((String)"accelerometer_rotation");
            this._appCxt.getContentResolver().registerContentObserver(uri, false, this._observer);
            this.mRotation = this.mDisplay.getRotation();
            Point point = new Point();
            this.mDisplay.getSize(point);
            if (n == 0 || n2 == 0) {
                this.mWidth = point.x;
                this.mHeight = point.y;
            } else if (point.x > point.y && n > n2) {
                this.mWidth = n;
                this.mHeight = n2;
            } else {
                this.mWidth = n2;
                this.mHeight = n;
            }
            int n4 = this.mWidth * this.mHeight * 3 / 2;
            if (this._bufI420 == null || n4 > this._bufI420.capacity()) {
                this._bufI420 = ByteBuffer.allocateDirect(n4).order(ByteOrder.nativeOrder());
            }
            this.mImageReader = ImageReader.newInstance((int)this.mWidth, (int)this.mHeight, (int)1, (int)2);
            this._format = 4;
            try {
                this.mVirtualDisplay = sMediaProjection.createVirtualDisplay(ZmfVideo.CaptureScreen, this.mWidth, this.mHeight, 240, 17, this.mImageReader.getSurface(), null, null);
            }
            catch (Exception exception) {
                ZmfVideo.onErrorOccurred("screen capture:" + exception.getLocalizedMessage());
                return -1;
            }
            new Thread(){

                @Override
                public void run() {
                    Looper.prepare();
                    ScreenCapture.this.mHandler = new Handler();
                    Looper.loop();
                }
            }.start();
            this.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)new ImageAvailableListener(), this.mHandler);
            sMediaProjection.registerCallback((MediaProjection.Callback)new MediaProjectionStopCallback(), this.mHandler);
            this.mStarted = true;
            ZmfVideo.logInfo("screen capture started");
            return 0;
        }
        if (!this.mIsStarting.booleanValue()) {
            try {
                Intent intent = new Intent(this._appCxt, ZmfActivity.class);
                intent.addFlags(0x10000000);
                this._appCxt.startActivity(intent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ZmfVideo.onErrorOccurred("Screen:failed to start ZmfActivity!");
                return -1;
            }
        }
        this.mIsStarting = true;
        this.mWidth = n;
        this.mHeight = n2;
        return 0;
    }

    @SuppressLint(value={"NewApi"})
    public int stop() {
        this.disable();
        if (this.mVirtualDisplay != null) {
            this.mVirtualDisplay.release();
            this.mVirtualDisplay = null;
        }
        if (this.mImageReader != null) {
            this.mImageReader.setOnImageAvailableListener(null, null);
            this.mImageReader = null;
        }
        if (this._observer != null) {
            this._appCxt.getContentResolver().unregisterContentObserver(this._observer);
            this._observer = null;
        }
        if (this.mStarted.booleanValue()) {
            this.mStarted = false;
            ZmfVideo.onCaptureDidStop(ZmfVideo.CaptureScreen);
            ZmfVideo.logInfo("screen capture stopped");
        } else {
            ZmfVideo.logInfo("screen capture already stopped");
        }
        return 0;
    }

    static {
        screenNum = 0;
    }

    @SuppressLint(value={"NewApi"})
    private class MediaProjectionStopCallback
    extends MediaProjection.Callback {
        private MediaProjectionStopCallback() {
        }

        public void onStop() {
            Log.e((String)"ScreenCapture", (String)"stopping projection.");
            if (sMediaProjection != null) {
                sMediaProjection.unregisterCallback((MediaProjection.Callback)this);
            }
            ScreenCapture.this.stop();
        }
    }

    @SuppressLint(value={"NewApi"})
    private class ImageAvailableListener
    implements ImageReader.OnImageAvailableListener {
        private ImageAvailableListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onImageAvailable(ImageReader imageReader) {
            Image image = null;
            if (!ScreenCapture.this.mStarted.booleanValue()) {
                return;
            }
            try {
                image = ScreenCapture.this.mImageReader.acquireLatestImage();
                if (image != null) {
                    long l = SystemClock.elapsedRealtime();
                    if (l - ScreenCapture.this.mLastTimeMs < (long)ScreenCapture.this.mDurationMs) {
                        image.close();
                        return;
                    }
                    do {
                        ScreenCapture.this.mLastTimeMs = ScreenCapture.this.mLastTimeMs + (long)ScreenCapture.this.mDurationMs;
                    } while (ScreenCapture.this.mLastTimeMs + (long)ScreenCapture.this.mDurationMs <= l);
                    Image.Plane[] planeArray = image.getPlanes();
                    ByteBuffer byteBuffer = planeArray[0].getBuffer();
                    int n = image.getWidth();
                    int n2 = image.getHeight();
                    int n3 = planeArray[0].getPixelStride();
                    int n4 = planeArray[0].getRowStride();
                    int n5 = n4 - n3 * n;
                    int n6 = n3 * n;
                    int n7 = n6 * n2;
                    if (byteBuffer == null || byteBuffer.remaining() < n7) {
                        image.close();
                        return;
                    }
                    if (ScreenCapture.this._tempBuf == null || ScreenCapture.this._tempBuf.capacity() < n7) {
                        ScreenCapture.this._tempBuf = ByteBuffer.allocateDirect(n7).order(ByteOrder.nativeOrder());
                    }
                    ScreenCapture.this._tempBuf.position(0);
                    if (n4 == n6) {
                        byteBuffer.limit(byteBuffer.position() + n7);
                        ScreenCapture.this._tempBuf.put(byteBuffer);
                    } else {
                        if (ScreenCapture.this._midBuf == null || ScreenCapture.this._midBuf.length < n4) {
                            ScreenCapture.this._midBuf = new byte[n4];
                        }
                        for (int i = 0; i < n2; ++i) {
                            byteBuffer.get(ScreenCapture.this._midBuf, 0, n4);
                            ScreenCapture.this._tempBuf.put(ScreenCapture.this._midBuf, 0, n6);
                        }
                    }
                    ZmfVideo.convertToI420(ScreenCapture.this._bufI420, ScreenCapture.this._format, ScreenCapture.this._tempBuf, n, n2, 0);
                    ZmfVideo.onCapture(ZmfVideo.CaptureScreen, 0, ScreenCapture.this.mRotateAngle, 0, n, n2, ScreenCapture.this._bufI420);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (image != null) {
                    image.close();
                }
            }
        }
    }
}

