/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import android.util.Range;
import com.justalk.cloud.zmf.Zmf;
import com.justalk.cloud.zmf.ZmfMediaCodec;
import com.justalk.cloud.zmf.ZmfVideo;
import java.nio.ByteBuffer;
import java.util.Arrays;

class H265Codec
extends ZmfMediaCodec {
    protected static final int kNALTypeIDR = 19;
    protected static final int kNALTypeVPS = 32;
    protected static final int kNALTypeSPS = 33;
    protected static final int kNALTypePPS = 34;
    protected static final int kNALTypeBad = -1;
    protected static final byte[] ANNEXB_HEAD = new byte[]{0, 0, 0, 1};
    ByteBuffer mSps;
    ByteBuffer mPps;
    ByteBuffer mVps;
    boolean mNextKeyframe;
    boolean mKeyframe;
    int mColorFormat;
    int mSetWidth;
    int mWidth;
    int mSetHeight;
    int mHeight;
    int mCropLeft;
    int mCropRight;
    int mCropTop;
    int mCropBot;
    int mCroppedWidth;
    int mCroppedHeight;
    int mStride;
    int mSliceHeight;
    ByteBuffer mBufI420;
    int mNextBitRateKbps;
    int mBitRateKbps;
    boolean mAdjustBr;
    int mMaxFrameRate;
    int mSetFrameRate;
    int mBitrateMode = 0;
    long mLastTimeAdjustBr;
    Range<Integer> mBitrateRange = null;
    static MediaCodecInfo[] H265_CODEC_INFO_LIST = null;
    static int H265_CODEC_INFO_COUNT = 0;
    private static final String[] H265_HW_EXCEPTION_MODELS = new String[0];
    private static final String[] H265_Supported_Prefix = new String[]{"qcom", "Exynos"};

    private int setBitrate(MediaCodec mediaCodec, int n) {
        long l = SystemClock.elapsedRealtime();
        if (l - this.mLastTimeAdjustBr <= 1000L) {
            return 0;
        }
        this.mLastTimeAdjustBr = l;
        this.mBitRateKbps = n;
        int n2 = n * 1000;
        if (this.mAdjustBr) {
            n2 = this.mMaxFrameRate * n2 / this.mSetFrameRate;
        }
        if (this.mBitrateRange != null) {
            n2 = (Integer)this.mBitrateRange.clamp((Comparable)Integer.valueOf(n2));
        }
        Bundle bundle = new Bundle(1);
        bundle.putInt("video-bitrate", n2);
        try {
            mediaCodec.setParameters(bundle);
        }
        catch (Exception exception) {
            return this.MEDIA_CODEC_ERROR(exception);
        }
        Log.d((String)this.TAG, (String)("BitRate=" + n));
        return 0;
    }

    @Override
    protected int set(int n, byte[] byArray) {
        switch (n) {
            case 10: {
                this.mSps = ByteBuffer.allocate(ANNEXB_HEAD.length + byArray.length);
                this.mSps.put(ANNEXB_HEAD).put(byArray);
                this.mSps.clear();
                return 0;
            }
            case 11: {
                this.mPps = ByteBuffer.allocate(ANNEXB_HEAD.length + byArray.length);
                this.mPps.put(ANNEXB_HEAD).put(byArray);
                this.mPps.clear();
            }
            case 12: {
                this.mVps = ByteBuffer.allocate(ANNEXB_HEAD.length + byArray.length);
                this.mVps.put(ANNEXB_HEAD).put(byArray);
                this.mVps.clear();
                return 0;
            }
        }
        return this.MEDIA_CODEC_ERROR("invalid param" + n);
    }

    @Override
    protected int set(int n, int n2) {
        switch (n) {
            case 1: {
                if (this.mBitrateMode != 0) {
                    this.mNextBitRateKbps = n2;
                }
                return 0;
            }
            case 0: {
                this.mNextKeyframe = true;
                return 0;
            }
            case 2: {
                this.mSetFrameRate = n2;
                return 0;
            }
            case 6: 
            case 7: {
                return 0;
            }
        }
        return this.MEDIA_CODEC_ERROR("invalid param" + n);
    }

    @Override
    protected int get(int n) {
        switch (n) {
            case 4: {
                return this.mCroppedWidth;
            }
            case 5: {
                return this.mCroppedHeight;
            }
            case 9: {
                return 1;
            }
            case 0: {
                return this.mKeyframe ? 1 : 0;
            }
            case 8: {
                return 0;
            }
        }
        return this.MEDIA_CODEC_ERROR("invalid param" + n);
    }

    private int resetH265Decoder(long l) {
        if (this.mSps == null || this.mPps == null || this.mVps == null) {
            return -1;
        }
        int n = this.configGetInt(l, "video.width");
        int n2 = this.configGetInt(l, "video.height");
        if (this.mSetWidth == n && this.mSetHeight == n2) {
            return 0;
        }
        this.stopMediaCodec();
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)"video/hevc", (int)n, (int)n2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.mVps.capacity() + 4 + this.mSps.capacity() + this.mPps.capacity());
        byteBuffer.put(this.mVps).put(this.mSps).put(this.mPps);
        byteBuffer.clear();
        mediaFormat.setByteBuffer("csd-0", byteBuffer);
        this.mWidth = this.mCroppedWidth = n;
        this.mSetWidth = this.mCroppedWidth;
        this.mHeight = this.mCroppedHeight = n2;
        this.mSetHeight = this.mCroppedHeight;
        this.mCropBot = 0;
        this.mCropTop = 0;
        this.mCropRight = 0;
        this.mCropLeft = 0;
        this.mStride = n;
        this.mSliceHeight = n2;
        this.mColorFormat = 19;
        return this.startMediaCodec(mediaFormat, 0);
    }

    static boolean isSupported(boolean bl) {
        Object object;
        Object object2;
        if (H265_CODEC_INFO_LIST == null) {
            MediaCodecInfo[] mediaCodecInfoArray;
            object2 = new MediaCodecInfo[64];
            MediaCodecList mediaCodecList = new MediaCodecList(0);
            MediaCodecInfo[] mediaCodecInfoArray2 = mediaCodecInfoArray = mediaCodecList.getCodecInfos();
            int n = mediaCodecInfoArray2.length;
            block2: for (int i = 0; i < n; ++i) {
                object = mediaCodecInfoArray2[i];
                if (!object.isEncoder()) continue;
                try {
                    MediaCodecInfo.CodecCapabilities codecCapabilities = object.getCapabilitiesForType("video/hevc");
                    int[] nArray = codecCapabilities.colorFormats;
                    int n2 = nArray.length;
                    for (int j = 0; j < n2; ++j) {
                        int n3 = nArray[j];
                        if (n3 != 19 && n3 != 21) continue;
                        String string = object.getName();
                        Log.i((String)"ZMF", (String)("H265 find encoder name: " + string));
                        if (H265_CODEC_INFO_COUNT >= ((Object)object2).length) continue block2;
                        Log.i((String)"ZMF", (String)("H265 add encoder name: " + string));
                        object2[H265Codec.H265_CODEC_INFO_COUNT++] = object;
                        continue block2;
                    }
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            H265_CODEC_INFO_LIST = (MediaCodecInfo[])Arrays.copyOf(object2, H265_CODEC_INFO_COUNT);
        }
        if (H265_CODEC_INFO_COUNT > 0) {
            if (!bl) {
                object2 = Arrays.asList(H265_HW_EXCEPTION_MODELS);
                if (object2.contains(Build.MODEL)) {
                    Log.i((String)"ZMF", (String)("H265 Encoder on blacklist: " + Build.MODEL));
                    return false;
                }
                boolean bl2 = false;
                for (MediaCodecInfo mediaCodecInfo : H265_CODEC_INFO_LIST) {
                    object = mediaCodecInfo.getName();
                    for (MediaCodecInfo.CodecCapabilities codecCapabilities : H265_Supported_Prefix) {
                        if (!((String)object).contains((CharSequence)codecCapabilities)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) break;
                }
                if (!bl2) {
                    Log.i((String)"ZMF", (String)"H265 Encoder soc not on whitelist");
                    return false;
                }
            }
            Log.i((String)"ZMF", (String)("H265 Encoder supported(" + bl + "): " + Build.MODEL));
            return true;
        }
        return false;
    }

    private int resetH265Encoder(long l) {
        Object object;
        int n;
        int n2 = this.configGetInt(l, "video.width");
        int n3 = this.configGetInt(l, "video.height");
        int n4 = this.configGetInt(l, "video.maxFramerate");
        int n5 = this.configGetInt(l, "video.startBitrate");
        if (this.mSetWidth == n2 && this.mSetHeight == n3 && this.mMaxFrameRate == n4 && this.mBitRateKbps == n5) {
            return 0;
        }
        MediaCodecInfo mediaCodecInfo = H265_CODEC_INFO_LIST[0];
        String string = mediaCodecInfo.getName();
        int n6 = n = string.contains("sprd") ? this.release() : this.stopMediaCodec();
        if (n != 0) {
            return n;
        }
        this.mAdjustBr = !string.contains("qcom");
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)"video/hevc", (int)n2, (int)n3);
        MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType("video/hevc");
        MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
        MediaCodecInfo.EncoderCapabilities encoderCapabilities = codecCapabilities.getEncoderCapabilities();
        mediaFormat.setString("codec-name", mediaCodecInfo.getName());
        if (!videoCapabilities.areSizeAndRateSupported(n2, n3, (double)n4)) {
            try {
                object = videoCapabilities.getSupportedFrameRatesFor(n2, n3);
                if (object == null) {
                    return this.MEDIA_CODEC_ERROR("don't supprot size and rate!");
                }
                n4 = ((Double)object.clamp((Comparable)Double.valueOf(n4))).intValue();
            }
            catch (Exception exception) {
                return this.MEDIA_CODEC_ERROR("don't support size " + n2 + "x" + n3);
            }
        }
        this.mBitrateRange = videoCapabilities.getBitrateRange();
        if (this.mBitrateRange != null) {
            n5 = (Integer)this.mBitrateRange.clamp((Comparable)Integer.valueOf(n5 * 1000)) / 1000;
        }
        this.mSetWidth = this.mWidth = n2;
        this.mSetHeight = this.mHeight = n3;
        this.mMaxFrameRate = n4;
        this.mBitRateKbps = this.mNextBitRateKbps = n5;
        object = false;
        if (string.contains("MTK")) {
            for (int n7 : codecCapabilities.colorFormats) {
                if (n7 != 2135033992) continue;
                object = true;
                this.mColorFormat = n7;
                break;
            }
        }
        if (!((Boolean)object).booleanValue()) {
            for (int n7 : codecCapabilities.colorFormats) {
                if (n7 != 19 && n7 != 21) continue;
                this.mColorFormat = n7;
                break;
            }
        }
        int n8 = 1;
        mediaFormat.setInteger("i-frame-interval", 65535);
        mediaFormat.setInteger("color-format", this.mColorFormat);
        mediaFormat.setInteger("stride", this.mSetWidth);
        mediaFormat.setInteger("slice-height", this.mSetHeight);
        mediaFormat.setFloat("frame-rate", (float)this.mMaxFrameRate);
        mediaFormat.setInteger("bitrate", this.mBitRateKbps * 1000);
        int n9 = 0;
        int n10 = this.mSetWidth * this.mSetHeight;
        n9 = n10 <= 101376 ? 4 : (n10 <= 230400 ? 16 : (n10 <= 518400 ? 64 : (n10 <= 921600 ? 256 : 1024)));
        for (MediaCodecInfo.CodecProfileLevel codecProfileLevel : codecCapabilities.profileLevels) {
            if (codecProfileLevel.profile < n8 || codecProfileLevel.level < n9) continue;
            mediaFormat.setInteger("profile", codecProfileLevel.profile);
            mediaFormat.setInteger("level", n9);
            break;
        }
        this.mBitrateMode = 2;
        mediaFormat.setInteger("bitrate-mode", this.mBitrateMode);
        mediaFormat.setInteger("store-metadata-in-buffers", 0);
        mediaFormat.setInteger("VideoMinQP", this.configGetInt(l, "video.qpMin"));
        mediaFormat.setInteger("VideoMaxQP", this.configGetInt(l, "video.qpMax"));
        Log.i((String)this.TAG, (String)("BitrateRange " + this.mBitrateRange + " Bitratemode " + this.mBitrateMode));
        this.mNextKeyframe = false;
        this.mLastTimeAdjustBr = SystemClock.elapsedRealtime();
        return this.startMediaCodec(mediaFormat, 1);
    }

    @Override
    protected int resetMediaCodec(long l) {
        if (l == 0L) {
            this.mSps = null;
            this.mPps = null;
            this.mVps = null;
            return this.stopMediaCodec();
        }
        if (this.isEncoder()) {
            return this.resetH265Encoder(l);
        }
        return this.resetH265Decoder(l);
    }

    @Override
    protected ByteBuffer onInputBuffer(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo, MediaCodec mediaCodec) {
        this.mKeyframe = false;
        if (!this.isEncoder()) {
            bufferInfo.size = byteBuffer.capacity();
            int n = (byteBuffer.get(4) & 0x7E) >> 1;
            if (this.mNextKeyframe || n == 19) {
                bufferInfo.flags |= 1;
            } else if (n == 33 || n == 34 || n == 32) {
                bufferInfo.flags |= 2;
            }
            this.mNextKeyframe = false;
            return byteBuffer;
        }
        if (this.mBitRateKbps != this.mNextBitRateKbps) {
            this.setBitrate(mediaCodec, this.mNextBitRateKbps);
        }
        if (this.mNextKeyframe) {
            bufferInfo.flags |= 1;
        }
        this.mNextKeyframe = false;
        switch (this.mColorFormat) {
            case 21: {
                bufferInfo.size = byteBuffer.capacity();
                if (this.mBufI420 == null || this.mBufI420.capacity() < bufferInfo.size) {
                    this.mBufI420 = ByteBuffer.allocateDirect(bufferInfo.size);
                }
                this.mBufI420.clear();
                this.mBufI420.limit(bufferInfo.size);
                if (0 <= ZmfVideo.convertFromI420(this.mBufI420, 14, byteBuffer, this.mSetWidth, this.mSetHeight)) {
                    return this.mBufI420;
                }
                return null;
            }
            case 2135033992: {
                bufferInfo.size = byteBuffer.capacity();
                if (this.mBufI420 == null || this.mBufI420.capacity() < bufferInfo.size) {
                    this.mBufI420 = ByteBuffer.allocateDirect(bufferInfo.size);
                }
                this.mBufI420.clear();
                this.mBufI420.limit(bufferInfo.size);
                if (0 <= ZmfVideo.convertFromI420(this.mBufI420, 10, byteBuffer, this.mSetWidth, this.mSetHeight)) {
                    return this.mBufI420;
                }
                return null;
            }
            case 19: {
                bufferInfo.size = byteBuffer.capacity();
                return byteBuffer;
            }
        }
        return null;
    }

    @Override
    protected ByteBuffer onOutputBuffer(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        if (!this.isEncoder()) {
            switch (this.mColorFormat) {
                case 21: {
                    if (this.mBufI420 == null || this.mBufI420.capacity() < bufferInfo.size) {
                        this.mBufI420 = ByteBuffer.allocateDirect(bufferInfo.size);
                    }
                    this.mBufI420.clear();
                    this.mBufI420.limit(bufferInfo.size);
                    int[] nArray = new int[]{this.mCroppedWidth, this.mCroppedHeight};
                    if (0 <= Zmf.convertToI420(this.mBufI420, 14, byteBuffer, this.mStride, this.mSliceHeight, 0, this.mCropLeft, this.mCropTop, nArray)) {
                        bufferInfo.size = nArray[0] * nArray[1] * 3 / 2;
                        return this.mBufI420;
                    }
                    return null;
                }
                case 19: {
                    return byteBuffer;
                }
            }
            return null;
        }
        int n = (byteBuffer.get(4) & 0x7E) >> 1;
        if ((bufferInfo.flags & 1) != 0) {
            this.mKeyframe = true;
        } else if (n == 33 || n == 34 || n == 19 || n == 32) {
            this.mKeyframe = true;
        }
        if (bufferInfo.size < 80 && (n == 33 || n == 34 || n == 32)) {
            bufferInfo.flags |= 0x1000;
        }
        return byteBuffer;
    }

    @Override
    protected void onOutputFormatChanged(MediaFormat mediaFormat) {
        if (mediaFormat.containsKey("width")) {
            this.mWidth = mediaFormat.getInteger("width");
        }
        if (mediaFormat.containsKey("height")) {
            this.mHeight = mediaFormat.getInteger("height");
        }
        if (mediaFormat.containsKey("color-format")) {
            this.mColorFormat = mediaFormat.getInteger("color-format");
        }
        if (mediaFormat.containsKey("stride")) {
            this.mStride = mediaFormat.getInteger("stride");
        }
        if (mediaFormat.containsKey("slice-height")) {
            this.mSliceHeight = mediaFormat.getInteger("slice-height");
        }
        if (mediaFormat.containsKey("crop-left") && mediaFormat.containsKey("crop-right") && mediaFormat.containsKey("crop-bottom") && mediaFormat.containsKey("crop-top")) {
            this.mCropLeft = mediaFormat.getInteger("crop-left");
            this.mCropRight = mediaFormat.getInteger("crop-right");
            this.mCropBot = mediaFormat.getInteger("crop-bottom");
            this.mCropTop = mediaFormat.getInteger("crop-top");
            this.mCroppedWidth = 1 + this.mCropRight - this.mCropLeft;
            this.mCroppedHeight = 1 + this.mCropBot - this.mCropTop;
        } else {
            this.mCroppedWidth = this.mWidth;
            this.mCroppedHeight = this.mHeight;
        }
        this.mStride = Math.max(this.mStride, this.mWidth);
        this.mSliceHeight = Math.max(this.mSliceHeight, this.mHeight);
        Log.i((String)this.TAG, (String)String.format("%dx%d,color=%d,stride=%dx%d,crop %d-%d,%d-%d", this.mWidth, this.mHeight, this.mColorFormat, this.mStride, this.mSliceHeight, this.mCropLeft, this.mCropRight, this.mCropTop, this.mCropBot));
    }

    public H265Codec() {
        super("H265");
    }
}

