/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.content.Context;
import android.opengl.GLES10;
import android.opengl.GLES11;
import android.opengl.GLSurfaceView;
import android.opengl.Matrix;
import android.os.SystemClock;
import android.view.SurfaceHolder;
import android.view.View;
import com.justalk.cloud.zmf.EffectFx;
import com.justalk.cloud.zmf.EffectParam;
import com.justalk.cloud.zmf.MatchParam;
import com.justalk.cloud.zmf.Render;
import com.justalk.cloud.zmf.ZmfVideo;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.microedition.khronos.opengles.GL10;

abstract class GLView
extends GLSurfaceView
implements Render {
    protected Map<String, Layer> _layers = new HashMap<String, Layer>();
    private ArrayList<Layer> _orders = new ArrayList();
    protected boolean _drawing = false;
    private int _orient = -2;
    protected boolean _surfaceCreated = false;
    private int[] _vbo = new int[1];
    private final int VBUF_SIZE = 64;
    private FloatBuffer _vbuf = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected float[] _transform = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    public void requestRender() {
        if (this._drawing && this._surfaceCreated) {
            super.requestRender();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int videoRenderStart() {
        if (!this._drawing) {
            this._drawing = true;
            ArrayList<Layer> arrayList = this._orders;
            synchronized (arrayList) {
                for (Layer layer : this._orders) {
                    layer.width = 0;
                    layer.height = 0;
                }
            }
            this.onResume();
            this.requestRender();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void allocateGL() {
        ArrayList<Layer> arrayList = this._orders;
        synchronized (arrayList) {
            for (Layer layer : this._orders) {
                if (layer.dirty || layer.width <= 0 || layer.height <= 0) continue;
                boolean bl = false;
                if (layer.width > layer.texWidth || layer.height > layer.texHeight) {
                    layer.texWidth = GLView.minPowerOf2(layer.width);
                    layer.texHeight = GLView.minPowerOf2(layer.height);
                    bl = true;
                }
                this.onLayerPrepare(layer, true, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseGL() {
        if (this._vbo[0] != 0) {
            GLES11.glDeleteBuffers((int)1, (int[])this._vbo, (int)0);
            this._vbo[0] = 0;
            this.checkGlError("glDeleteBuffers");
        }
        ArrayList<Layer> arrayList = this._orders;
        synchronized (arrayList) {
            for (Layer layer : this._orders) {
                if (layer.texId != null) {
                    GLES10.glDeleteTextures((int)layer.texId.length, (int[])layer.texId, (int)0);
                    layer.texId = null;
                    this.checkGlError("glDeleteTextures");
                }
                layer.texHeight = 0;
                layer.texWidth = 0;
            }
        }
    }

    @Override
    public int videoRenderStop() {
        if (this._drawing) {
            this._drawing = false;
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    GLView.this.releaseGL();
                }
            });
            this.onPause();
        }
        return 0;
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                GLView.this.releaseGL();
            }
        });
        super.surfaceDestroyed(surfaceHolder);
    }

    protected void finalize() throws Throwable {
        this._orders.clear();
        Collection<Layer> collection = this._layers.values();
        for (Layer layer : collection) {
            ZmfVideo.renderRemoveCallback(layer.handle);
            if (layer.effect_param.effect != null) {
                for (EffectFx effectFx : layer.effect_param.effect) {
                    if (effectFx == null) continue;
                    effectFx.unref();
                }
            }
            ZmfVideo.logError(String.format(Locale.US, "renderStop() missing. remove[%d]:%s", layer.handle, layer.renderId));
        }
        this._layers.clear();
        super.finalize();
    }

    @Override
    public boolean has(String string) {
        return this._layers.get(string) != null;
    }

    @Override
    public boolean isActive() {
        return this._drawing || this._layers.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int videoRenderAdd(String string, int n, int n2) {
        Layer layer = this._layers.get(string);
        if (layer == null) {
            layer = new Layer();
            layer.view = this;
            layer.renderId = string;
            layer.zOrder = n;
            layer.fullMode = n2;
            layer.bufWidth = 0;
            layer.bufHeight = 0;
            layer.width = 0;
            layer.height = 0;
            layer.sxRatio = 1.0f;
            layer.syRatio = 1.0f;
            layer.cfgMirror = 7;
            layer.bufMirror = -1;
            this._layers.put(string, layer);
            layer.handle = ZmfVideo.renderAddCallback(layer);
            ArrayList<Layer> arrayList = this._orders;
            synchronized (arrayList) {
                this.orderLayer(layer);
            }
        }
        ArrayList<Layer> arrayList = this._orders;
        synchronized (arrayList) {
            layer.fullMode = n2;
            layer.bufWidth = 0;
            layer.bufHeight = 0;
            layer.width = 0;
            layer.height = 0;
            if (layer.zOrder != n) {
                layer.zOrder = n;
                this._orders.remove(layer);
                this.orderLayer(layer);
            }
        }
        ZmfVideo.logInfo(String.format(Locale.US, "add[%d]:%s", layer.handle, layer.renderId));
        return 0;
    }

    @Override
    public int videoRenderReplace(String string, String string2) {
        Layer layer = this._layers.get(string);
        if (layer == null) {
            return -1;
        }
        layer.renderId = string2;
        layer.bufMirror = -1;
        this._layers.remove(string);
        this._layers.put(string2, layer);
        return 0;
    }

    @Override
    public int videoRenderFillMode(String string, int n) {
        Layer layer = this._layers.get(string);
        if (layer == null) {
            return -1;
        }
        layer.fullMode = n;
        this.requestRender();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int videoRenderRemove(String string) {
        Layer layer = this._layers.get(string);
        if (layer == null) {
            return -1;
        }
        this._layers.remove(string);
        EffectFx[] effectFxArray = this._orders;
        synchronized (this._orders) {
            this._orders.remove(layer);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            ZmfVideo.renderRemoveCallback(layer.handle);
            if (layer.effect_param != null && layer.effect_param.effect != null) {
                for (EffectFx effectFx : layer.effect_param.effect) {
                    if (effectFx == null) continue;
                    effectFx.unref();
                }
            }
            ZmfVideo.logInfo(String.format(Locale.US, "remove[%d]:%s", layer.handle, layer.renderId));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int videoRenderRemoveAll() {
        Collection<Layer> collection = this._orders;
        synchronized (collection) {
            this._orders.clear();
        }
        collection = this._layers.values();
        for (Layer layer : collection) {
            ZmfVideo.renderRemoveCallback(layer.handle);
            if (layer.effect_param != null && layer.effect_param.effect != null) {
                for (EffectFx effectFx : layer.effect_param.effect) {
                    if (effectFx == null) continue;
                    effectFx.unref();
                }
            }
            ZmfVideo.logInfo(String.format(Locale.US, "remove[%d]:%s", layer.handle, layer.renderId));
        }
        this._layers.clear();
        return 0;
    }

    @Override
    public int videoRenderMove(String string, float f, float f2, float f3, float f4) {
        Layer layer = this._layers.get(string);
        if (layer == null) {
            return -1;
        }
        layer.offsetX = f + f3 - 1.0f;
        layer.offsetY = 1.0f - (f2 + f4);
        layer.radiusX = f3 - f;
        layer.radiusY = f4 - f2;
        this.requestRender();
        return 0;
    }

    @Override
    public int videoRenderRotate(int n) {
        this._orient = n;
        this.requestRender();
        return 0;
    }

    @Override
    public int videoRenderMirror(String string, int n) {
        Layer layer = this._layers.get(string);
        if (layer == null) {
            return -1;
        }
        if (layer.cfgMirror != n) {
            layer.cfgMirror = n;
            layer.bufMirror = -1;
            this.requestRender();
        }
        return 0;
    }

    @Override
    public int videoRenderFreeze(String string, boolean bl) {
        Layer layer = this._layers.get(string);
        if (layer == null) {
            return -1;
        }
        layer.freeze = bl;
        return 0;
    }

    private static int minPowerOf2(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    private void orderLayer(Layer layer) {
        int n;
        for (n = this._orders.size() - 1; n >= 0; --n) {
            Layer layer2 = this._orders.get(n);
            if (layer2.zOrder > layer.zOrder) {
                continue;
            }
            if (layer2.zOrder == layer.zOrder) {
                this._orders.set(n, layer);
                break;
            }
            if (layer2.zOrder >= layer.zOrder) break;
            this._orders.add(n + 1, layer);
            break;
        }
        if (n < 0) {
            this._orders.add(0, layer);
        }
    }

    public GLView(Context context) {
        super(context);
    }

    abstract void onLayerPrepare(Layer var1, boolean var2, boolean var3);

    abstract void onLayerDraw(Layer var1);

    public void onDrawFrame(GL10 gL10) {
        try {
            this.onRender(gL10);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRender(GL10 gL10) {
        boolean bl;
        int n;
        if (!this._surfaceCreated || !this._drawing) {
            return;
        }
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        ArrayList<Layer> arrayList = this._orders;
        synchronized (arrayList) {
            for (Layer layer : this._orders) {
                if (layer.dirty) {
                    int n4 = n = layer.angle == 90 || layer.angle == 270 ? 1 : 0;
                    if (layer.match_param != null && layer.match_param.matchType == 1 && layer.match_param.timeStampMs <= layer.timeStampMs) {
                        ZmfVideo.renderEffect((View)this, layer.renderId, 0, null, null);
                        layer.match_param.matchType = 0;
                    }
                    if (layer.width == 0 || layer.height == 0) {
                        ZmfVideo.onRenderDidStart((View)this, layer.sourceType, layer.renderId, n != 0 ? layer.bufHeight : layer.bufWidth, n != 0 ? layer.bufWidth : layer.bufHeight);
                    } else if (layer.width != layer.bufWidth || layer.height != layer.bufHeight) {
                        ZmfVideo.onRenderDidResize((View)this, layer.sourceType, layer.renderId, n != 0 ? layer.bufHeight : layer.bufWidth, n != 0 ? layer.bufWidth : layer.bufHeight);
                    }
                    layer.width = layer.bufWidth;
                    layer.height = layer.bufHeight;
                    bl = false;
                    if (layer.width > layer.texWidth || layer.height > layer.texHeight) {
                        layer.texWidth = GLView.minPowerOf2(layer.width);
                        layer.texHeight = GLView.minPowerOf2(layer.height);
                        bl = true;
                    }
                    this.onLayerPrepare(layer, true, bl);
                    layer.dirty = false;
                    continue;
                }
                if (layer.texWidth <= 0 || layer.texHeight <= 0) continue;
                this.onLayerPrepare(layer, false, false);
            }
        }
        gL10.glClear(16384);
        if (this._vbo[0] == 0) {
            GLES11.glGenBuffers((int)1, (int[])this._vbo, (int)0);
            GLES11.glBindBuffer((int)34962, (int)this._vbo[0]);
            GLES11.glBufferData((int)34962, (int)64, (Buffer)this._vbuf.position(0), (int)35048);
            GLES11.glBindBuffer((int)34962, (int)0);
            this.checkGlError("glBufferData");
        }
        arrayList = this._orders;
        synchronized (arrayList) {
            for (Layer layer : this._orders) {
                float f;
                float f2;
                float f3;
                float f4;
                float f5;
                if (layer.texId == null || layer.texId[0] == 0) continue;
                this._vbuf.position(0);
                this._vbuf.put(-layer.radiusX);
                this._vbuf.put(layer.radiusY);
                this._vbuf.put(layer.radiusX);
                this._vbuf.put(layer.radiusY);
                this._vbuf.put(-layer.radiusX);
                this._vbuf.put(-layer.radiusY);
                this._vbuf.put(layer.radiusX);
                this._vbuf.put(-layer.radiusY);
                n = this._orient;
                if (n < 0) {
                    n = layer.sourceType == 1 ? (n == -2 ? ZmfVideo.sScreenOrient : (360 - ZmfVideo.renderOrientation()) % 360) : (n == -2 ? (ZmfVideo.renderOrientation() + ZmfVideo.sScreenOrient) % 360 : 0);
                }
                Matrix.setIdentityM((float[])this._transform, (int)0);
                Matrix.rotateM((float[])this._transform, (int)0, (float)n, (float)0.0f, (float)0.0f, (float)-1.0f);
                Matrix.translateM((float[])this._transform, (int)0, (float)layer.offsetX, (float)layer.offsetY, (float)0.0f);
                bl = n == 90 || n == 270;
                int n5 = layer.angle;
                float f6 = (float)(layer.height - 1) / (float)layer.texHeight;
                float f7 = (float)(layer.width - 1) / (float)layer.texWidth;
                float f8 = layer.radiusX * (float)(bl ? n3 : n2);
                float f9 = layer.radiusY * (float)(bl ? n2 : n3);
                if (n5 == 90 || n5 == 270) {
                    f5 = f8;
                    f8 = f9;
                    f9 = f5;
                }
                if ((f4 = (float)layer.width / f8) > (f3 = (float)layer.height / f9)) {
                    f2 = f3;
                    f = ((float)layer.width - f2 * f8) / (float)layer.width;
                } else {
                    f2 = f4;
                    f = ((float)layer.height - f2 * f9) / (float)layer.height;
                }
                layer.actualFullMode = layer.fullMode;
                if (layer.actualFullMode == -1) {
                    layer.actualFullMode = (double)f < 0.3 ? 0 : 1;
                }
                if (layer.actualFullMode == 1) {
                    if (n5 == 90 || n5 == 270) {
                        f5 = f4;
                        f4 = f3;
                        f3 = f5;
                    }
                    if (f4 <= f3) {
                        Matrix.scaleM((float[])this._transform, (int)0, (float)(f4 / f3), (float)1.0f, (float)1.0f);
                        layer.sxRatio = f4 / f3;
                        layer.syRatio = 1.0f;
                    } else {
                        Matrix.scaleM((float[])this._transform, (int)0, (float)1.0f, (float)(f3 / f4), (float)1.0f);
                        layer.sxRatio = 1.0f;
                        layer.syRatio = f3 / f4;
                    }
                    if (n5 == 90 || n5 == 270) {
                        f5 = layer.syRatio;
                        layer.syRatio = layer.sxRatio;
                        layer.sxRatio = f5;
                    }
                    f4 = 0.0f;
                    f3 = 0.0f;
                } else {
                    f4 = ((float)layer.width - f2 * f8) / 2.0f / (float)layer.texWidth;
                    f3 = ((float)layer.height - f2 * f9) / 2.0f / (float)layer.texHeight;
                    layer.sxRatio = 1.0f;
                    layer.syRatio = 1.0f;
                }
                layer.texTrans[0] = 1.0f / (f7 - 2.0f * f4);
                layer.texTrans[1] = f4 * layer.texTrans[0];
                layer.texTrans[2] = 1.0f / (f6 - 2.0f * f3);
                layer.texTrans[3] = f3 * layer.texTrans[2];
                float[] fArray = new float[8];
                switch (n5) {
                    case 90: {
                        fArray[0] = f4;
                        fArray[1] = f6 - f3;
                        fArray[2] = f4;
                        fArray[3] = f3;
                        fArray[4] = f7 - f4;
                        fArray[5] = f6 - f3;
                        fArray[6] = f7 - f4;
                        fArray[7] = f3;
                        break;
                    }
                    case 180: {
                        fArray[0] = f7 - f4;
                        fArray[1] = f6 - f3;
                        fArray[2] = f4;
                        fArray[3] = f6 - f3;
                        fArray[4] = f7 - f4;
                        fArray[5] = f3;
                        fArray[6] = f4;
                        fArray[7] = f3;
                        break;
                    }
                    case 270: {
                        fArray[0] = f7 - f4;
                        fArray[1] = f3;
                        fArray[2] = f7 - f4;
                        fArray[3] = f6 - f3;
                        fArray[4] = f4;
                        fArray[5] = f3;
                        fArray[6] = f4;
                        fArray[7] = f6 - f3;
                        break;
                    }
                    default: {
                        fArray[0] = f4;
                        fArray[1] = f3;
                        fArray[2] = f7 - f4;
                        fArray[3] = f3;
                        fArray[4] = f4;
                        fArray[5] = f6 - f3;
                        fArray[6] = f7 - f4;
                        fArray[7] = f6 - f3;
                    }
                }
                int n6 = layer.flipMirror & 3;
                if (n6 != 0) {
                    if (n6 == 1) {
                        this.swap(fArray, 0, 2);
                        this.swap(fArray, 1, 3);
                        this.swap(fArray, 4, 6);
                        this.swap(fArray, 5, 7);
                    } else if (n6 == 2) {
                        this.swap(fArray, 0, 4);
                        this.swap(fArray, 1, 5);
                        this.swap(fArray, 2, 6);
                        this.swap(fArray, 3, 7);
                    }
                }
                layer.sx = f4;
                layer.sy = f3;
                layer.sw = f7;
                layer.sh = f6;
                this._vbuf.put(fArray);
                GLES11.glBindBuffer((int)34962, (int)this._vbo[0]);
                GLES11.glBufferSubData((int)34962, (int)0, (int)64, (Buffer)this._vbuf.position(0));
                this.onLayerDraw(layer);
                GLES11.glBindBuffer((int)34962, (int)0);
            }
        }
    }

    private void swap(float[] fArray, int n, int n2) {
        float f = fArray[n];
        fArray[n] = fArray[n2];
        fArray[n2] = f;
    }

    protected void checkGlError(String string) {
        int n;
        while ((n = GLES10.glGetError()) != 0) {
            ZmfVideo.logError(string + ": glError " + n);
        }
    }

    @Override
    public float[] videoRenderRectPara(String string) {
        Layer layer = this._layers.get(string);
        if (layer == null) {
            return null;
        }
        float[] fArray = new float[]{layer.sx * (float)layer.texWidth, layer.sy * (float)layer.texHeight, layer.sxRatio, layer.syRatio};
        return fArray;
    }

    @Override
    public int videoRenderActualFillMode(String string) {
        Layer layer = this._layers.get(string);
        if (layer == null) {
            return -1;
        }
        return layer.actualFullMode;
    }

    protected class Layer
    implements ZmfVideo.RenderCallback {
        GLView view = null;
        String renderId = null;
        int zOrder;
        int fullMode;
        int actualFullMode;
        int angle;
        int flipMirror;
        int cfgMirror;
        int bufMirror;
        int bufWidth = 0;
        int bufHeight = 0;
        int width = 0;
        int height = 0;
        int texWidth = 0;
        int texHeight = 0;
        float sx;
        float sy;
        float sw;
        float sh;
        float sxRatio;
        float syRatio;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float radiusX = 1.0f;
        float radiusY = 1.0f;
        long rotateMs = 0L;
        int handle = -1;
        ByteBuffer yuvBuf = null;
        ByteBuffer texBuf = null;
        boolean dirty = false;
        boolean freeze = false;
        int sourceType = -1;
        int[] texId;
        int effectType = 0;
        EffectParam effect_param = null;
        MatchParam match_param = null;
        float[] texTrans = new float[4];
        int timeStampMs;

        protected Layer() {
        }

        @Override
        public boolean onFrame(String string, int n, int n2, int n3, int n4, int n5, ByteBuffer byteBuffer, int n6) {
            int n7;
            if (!this.renderId.equals(string)) {
                return false;
            }
            if (byteBuffer == null || n4 <= 0 || n5 <= 0) {
                ZmfVideo.onRenderRequestRemove((View)this.view, n, string);
                return true;
            }
            if (this.dirty) {
                return true;
            }
            if (this.freeze && this.width > 0 && this.height > 0) {
                return true;
            }
            this.timeStampMs = n6;
            if (this.angle != n2) {
                this.angle = n2;
                this.rotateMs = SystemClock.elapsedRealtime() + 1000L;
            }
            if (this.bufMirror != n3) {
                this.bufMirror = n3;
                n7 = this.cfgMirror & 3;
                this.flipMirror = n7 == 3 ? (n == 1 ? n3 : 0) : n7;
                if (this.sourceType == n) {
                    this.rotateMs = SystemClock.elapsedRealtime() + 1000L;
                }
            }
            if (this.bufWidth != n4 || this.bufHeight != n5) {
                n7 = n4 * n5 * 3 / 2;
                if (this.yuvBuf == null || this.yuvBuf.capacity() < n7) {
                    try {
                        this.yuvBuf = ByteBuffer.allocateDirect(n7).order(ByteOrder.nativeOrder());
                    }
                    catch (Throwable throwable) {
                        ZmfVideo.logError("Failed to allocateDirect()");
                        return true;
                    }
                }
                if (this.bufWidth == 0 && this.bufHeight == 0) {
                    boolean bl = false;
                    if (n == 1) {
                        bl = this.angle == 90 || this.angle == 270;
                    }
                    ZmfVideo.onRenderDidReceive((View)this.view, n, this.renderId, bl ? n5 : n4, bl ? n4 : n5);
                }
                this.bufWidth = n4;
                this.bufHeight = n5;
            }
            if (this.sourceType != n) {
                this.sourceType = n;
            }
            this.yuvBuf.position(0);
            this.yuvBuf.put((ByteBuffer)byteBuffer.position(0));
            this.dirty = true;
            this.view.requestRender();
            return true;
        }
    }
}

