/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.UUID;

class JCUtils {
    JCUtils() {
    }

    public static String getAppVersion(Context context) {
        PackageManager pm = context.getPackageManager();
        String version = null;
        try {
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            version = String.valueOf(pi.versionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (version == null) {
            version = "";
        }
        return version;
    }

    public static String getSdkInfoDir(Context context) {
        File fileDir = context.getExternalFilesDir(null);
        String dir = fileDir != null ? fileDir.getAbsolutePath() : context.getFilesDir().getAbsolutePath();
        return dir;
    }

    public static boolean isFileExist(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return new File(path).exists();
    }

    public static long getFileSize(String path) {
        if (JCUtils.isFileExist(path)) {
            return new File(path).length();
        }
        return 0L;
    }

    public static byte[] getBytes(String path) {
        byte[] buffer = null;
        try {
            int n;
            File file = new File(path);
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public static String genFilePath(String directory, String suffix) {
        if (!new File(directory).mkdirs()) {
            return null;
        }
        return String.format(Locale.getDefault(), "%s/%s.%s", directory, UUID.randomUUID().toString(), suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeToFile(byte[] buffer, String filePath) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            File file = new File(filePath);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return true;
    }
}

