/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.content.Context;
import com.justalk.cloud.zmf.Audio;
import com.justalk.cloud.zmf.Zmf;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;

public final class ZmfAudio {
    public static final int AEC_AUTO = -1;
    public static final int AEC_OFF = 0;
    public static final int AEC_ON = 1;
    public static final int AGC_AUTO = -1;
    public static final int AGC_OFF = 0;
    public static final int AGC_ON = 1;
    public static final String OUTPUT_VOICE_CALL = "STREAM_VOICE_CALL";
    public static final String OUTPUT_SYSTEM = "STREAM_SYSTEM";
    public static final String OUTPUT_RING = "STREAM_RING";
    public static final String OUTPUT_MUSIC = "STREAM_MUSIC";
    public static final String OUTPUT_ALARM = "STREAM_ALARM";
    public static final String OUTPUT_NOTIFICATION = "STREAM_NOTIFICATION";
    public static final String OUTPUT_DTMF = "STREAM_DTMF";
    public static final String INPUT_DEFAULT = "DEFAULT";
    public static final String INPUT_MIC = "MIC";
    public static final String INPUT_VOICE_UPLINK = "VOICE_UPLINK";
    public static final String INPUT_VOICE_DOWNLINK = "VOICE_DOWNLINK";
    public static final String INPUT_VOICE_CALL = "VOICE_CALL";
    public static final String INPUT_CAMCORDER = "CAMCORDER";
    public static final String INPUT_VOICE_RECOGNITION = "VOICE_RECOGNITION";
    public static final String INPUT_VOICE_COMMUNICATION = "VOICE_COMMUNICATION";
    private static Audio sAudio;
    private static Set<Callback> sCallbacks;
    private static Set<InputCallback> sInputCallbacks;
    private static Set<OutputCallback> sOutputCallbacks;

    public static synchronized int initialize(Context context) {
        if (context == null) {
            ZmfAudio.logError("android context is null");
            return -1;
        }
        if (sAudio == null) {
            if (Zmf.initialize(context) != 0) {
                return -1;
            }
            ZmfAudio.logInfo("initialize Audio");
            context = context.getApplicationContext();
            sAudio = Audio.create(context);
            if (sAudio == null) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    public static synchronized int terminate() {
        ZmfAudio.trace("terminate:");
        if (sAudio != null) {
            ZmfAudio.logInfo("terminate Audio");
            sAudio = null;
            Zmf.terminate();
        }
        sCallbacks.clear();
        return 0;
    }

    public static void addCallback(Callback callback) {
        sCallbacks.add(callback);
    }

    public static void removeCallback(Callback callback) {
        sCallbacks.remove(callback);
    }

    public static void outputAddCallback(OutputCallback outputCallback) {
        sOutputCallbacks.add(outputCallback);
    }

    public static void outputRemoveCallback(OutputCallback outputCallback) {
        sOutputCallbacks.remove(outputCallback);
    }

    public static void inputAddCallback(InputCallback inputCallback) {
        sInputCallbacks.add(inputCallback);
    }

    public static void inputRemoveCallback(InputCallback inputCallback) {
        sInputCallbacks.remove(inputCallback);
    }

    public static int inputGetAudioSource(String string) {
        ZmfAudio.trace("inputGetAudioSource:" + string);
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return 0;
        }
        return sAudio.inputGetAudioSource(string);
    }

    public static int outputGetStreamType(String string) {
        ZmfAudio.trace("outputGetStreamType:" + string);
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return 0;
        }
        return sAudio.outputGetStreamType(string);
    }

    public static int outputGetCount() {
        ZmfAudio.trace("outputGetCount:");
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return 0;
        }
        return sAudio.outputGetCount();
    }

    public static int outputGetName(int n, String[] stringArray) {
        ZmfAudio.trace("outputGetName:" + n + "," + stringArray);
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return -1;
        }
        return sAudio.outputGetName(n, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int outputStart(String string, int n, int n2) {
        ZmfAudio.trace("outputStart:" + string + "," + n + "," + n2);
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return -1;
        }
        if (string == null) {
            ZmfAudio.logError("no audio output id");
            return -1;
        }
        Audio audio = sAudio;
        synchronized (audio) {
            return sAudio.outputStart(string, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int outputStop(String string) {
        ZmfAudio.trace("outputStop:" + string);
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return -1;
        }
        if (string == null) {
            ZmfAudio.logError("no audio output id");
            return -1;
        }
        Audio audio = sAudio;
        synchronized (audio) {
            return sAudio.outputStop(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int outputStopAll() {
        ZmfAudio.trace("outputStopAll:");
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return -1;
        }
        Audio audio = sAudio;
        synchronized (audio) {
            return sAudio.outputStopAll();
        }
    }

    public static int inputGetCount() {
        ZmfAudio.trace("inputGetCount:");
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return 0;
        }
        return sAudio.inputGetCount();
    }

    public static int inputGetName(int n, String[] stringArray) {
        ZmfAudio.trace("inputGetName:" + n + "," + stringArray);
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return -1;
        }
        return sAudio.inputGetName(n, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int inputStart(String string, int n, int n2, int n3, int n4) {
        ZmfAudio.trace("inputStart:" + string + "," + n + "," + n2 + "," + n3 + "," + n4);
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return -1;
        }
        if (string == null) {
            ZmfAudio.logError("no audio input id");
            return -1;
        }
        Audio audio = sAudio;
        synchronized (audio) {
            return sAudio.inputStart(string, n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int inputStop(String string) {
        ZmfAudio.trace("inputStop:" + string);
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return -1;
        }
        if (string == null) {
            ZmfAudio.logError("no audio input id");
            return -1;
        }
        Audio audio = sAudio;
        synchronized (audio) {
            return sAudio.inputStop(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int inputStopAll() {
        ZmfAudio.trace("inputStopAll:");
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return -1;
        }
        Audio audio = sAudio;
        synchronized (audio) {
            return sAudio.inputStopAll();
        }
    }

    public static void onOutput(String string, int n, int n2, ByteBuffer byteBuffer) {
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return;
        }
        Zmf.onAudioOutput(string, n, n2, byteBuffer);
        for (OutputCallback outputCallback : sOutputCallbacks) {
            outputCallback.onAudioOutputFrame(string, n, n2, byteBuffer);
        }
    }

    public static void onInput(String string, int n, int n2, ByteBuffer byteBuffer, int n3, int n4, int n5) {
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return;
        }
        for (InputCallback inputCallback : sInputCallbacks) {
            inputCallback.onAudioInputFrame(string, n, n2, byteBuffer, n3, n4, n5);
        }
        Zmf.onAudioInput(string, n, n2, byteBuffer, n3, n4, n5);
    }

    public static void onInputDidStop(String string) {
        ZmfAudio.trace("onInputDidStop:" + string);
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return;
        }
        Zmf.onAudioInputDidStop(string);
    }

    public static void onOutputDidStop(String string) {
        ZmfAudio.trace("onOutputDidStop:" + string);
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
            return;
        }
        Zmf.onAudioOutputDidStop(string);
    }

    static void outputRequestStart(String string, int n, int n2) {
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
        }
        for (Callback callback : sCallbacks) {
            callback.outputRequestStart(string, n, n2);
        }
    }

    static void outputRequestStop(String string) {
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
        }
        for (Callback callback : sCallbacks) {
            callback.outputRequestStop(string);
        }
    }

    static void outputDidStart(String string, int n, int n2) {
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
        }
        for (Callback callback : sCallbacks) {
            callback.outputDidStart(string, n, n2);
        }
    }

    static void inputRequestStart(String string, int n, int n2, int n3, int n4) {
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
        }
        for (Callback callback : sCallbacks) {
            callback.inputRequestStart(string, n, n2, n3, n4);
        }
    }

    static void inputRequestStop(String string) {
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
        }
        for (Callback callback : sCallbacks) {
            callback.inputRequestStop(string);
        }
    }

    static void inputDidStart(String string, int n, int n2) {
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
        }
        for (Callback callback : sCallbacks) {
            callback.inputDidStart(string, n, n2);
        }
    }

    static void audioErrorOccurred(String string) {
        if (sAudio == null) {
            ZmfAudio.logError("audio not initialized");
        }
        for (Callback callback : sCallbacks) {
            callback.audioErrorOccurred(string);
        }
    }

    private static void trace(String string) {
        ZmfAudio.logInfo("ZmfAudio." + string);
    }

    public static void logError(String string) {
        Zmf.zmfLog(3, string);
    }

    public static void logWarn(String string) {
        Zmf.zmfLog(2, string);
    }

    public static void logInfo(String string) {
        Zmf.zmfLog(1, string);
    }

    public static void logDebug(String string) {
        Zmf.zmfLog(0, string);
    }

    static {
        sCallbacks = new HashSet<Callback>();
        sInputCallbacks = new HashSet<InputCallback>();
        sOutputCallbacks = new HashSet<OutputCallback>();
    }

    public static interface OutputCallback {
        public void onAudioOutputFrame(String var1, int var2, int var3, ByteBuffer var4);
    }

    public static interface InputCallback {
        public void onAudioInputFrame(String var1, int var2, int var3, ByteBuffer var4, int var5, int var6, int var7);
    }

    public static interface Callback {
        public void inputRequestStart(String var1, int var2, int var3, int var4, int var5);

        public void inputRequestStop(String var1);

        public void inputDidStart(String var1, int var2, int var3);

        public void outputRequestStart(String var1, int var2, int var3);

        public void outputRequestStop(String var1);

        public void outputDidStart(String var1, int var2, int var3);

        public void audioErrorOccurred(String var1);
    }
}

