/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.opengl.GLES20;
import com.justalk.cloud.zmf.EffectFx;
import com.justalk.cloud.zmf.EffectParam;
import com.justalk.cloud.zmf.GLView;
import com.justalk.cloud.zmf.ZmfVideo;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class YuvMaskRender
extends EffectFx {
    ByteBuffer _maskBuf;
    int _maskWidth;
    int _maskHeight;
    float[] _off = new float[4];

    YuvMaskRender() {
        this._texId = new int[]{-4, -3, -2, 0};
    }

    @Override
    boolean compile(GLView.Layer layer) {
        int n;
        String string = "precision mediump float;\nuniform sampler2D _tex[4];\nuniform vec4 texTrans;\nvarying vec2 vTextureCoord;\nvoid main(void) {\n  float y,u,v,a;\n  y=texture2D(_tex[0],vTextureCoord).r;\n  u=texture2D(_tex[1],vTextureCoord).r-0.5;\n  v=texture2D(_tex[2],vTextureCoord).r-0.5;\n  y=1.1643*(y-0.0625);\n  gl_FragColor =vec4(y+1.5958*v,y-0.39173*u-0.81290*v,y+2.017*u,1.0);\n  u = vTextureCoord.x*texTrans.x-texTrans.y;\n  v = vTextureCoord.y*texTrans.z-texTrans.w;\n  gl_FragColor = gl_FragColor * texture2D(_tex[3],vec2(u,v)).r;\n}";
        EffectParam effectParam = layer.effect_param;
        for (n = 0; n < effectParam.argc; ++n) {
            if (effectParam.name[n].equals("width")) {
                this._maskWidth = (int)effectParam.value[n];
                continue;
            }
            if (effectParam.name[n].equals("height")) {
                this._maskHeight = (int)effectParam.value[n];
                continue;
            }
            if (!effectParam.name[n].equals("bitmap")) continue;
            int n2 = (int)effectParam.value[n];
            if (effectParam.objects == null || n2 >= effectParam.objects.length) continue;
            this._maskBuf = (ByteBuffer)effectParam.objects[n2];
        }
        if (this._maskBuf == null || this._maskWidth == 0 || this._maskHeight == 0) {
            ZmfVideo.logError("mask param invalid");
            return false;
        }
        n = this.load("attribute vec4 aPosition;\nattribute vec2 aTextureCoord;\nuniform mat4 _mvp;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = _mvp*aPosition;\n  vTextureCoord = aTextureCoord;\n}", string) ? 1 : 0;
        if (n == 0) {
            ZmfVideo.logError("can't load yuv shader");
        }
        return n != 0;
    }

    @Override
    boolean upload_param(int n, GLView.Layer layer) {
        int n2;
        for (n2 = 0; n2 < 4; ++n2) {
            this._off[n2] = layer.texTrans[n2];
        }
        n2 = this._maskWidth;
        int n3 = this._maskHeight;
        ByteBuffer byteBuffer = this._maskBuf;
        EffectParam effectParam = layer.effect_param;
        for (int i = 0; i < effectParam.argc; ++i) {
            if (effectParam.name[i].equals("width")) {
                n2 = (int)effectParam.value[i];
                continue;
            }
            if (effectParam.name[i].equals("height")) {
                n3 = (int)effectParam.value[i];
                continue;
            }
            if (!effectParam.name[i].equals("bitmap")) continue;
            int n4 = (int)effectParam.value[i];
            if (effectParam.objects == null || n4 >= effectParam.objects.length) continue;
            byteBuffer = (ByteBuffer)effectParam.objects[n4];
        }
        if (byteBuffer == null || n2 == 0 || n3 == 0) {
            ZmfVideo.logError("mask param invalid");
            return false;
        }
        if (n2 != this._maskWidth || n3 != this._maskHeight) {
            GLES20.glDeleteTextures((int)1, (int[])this._texId, (int)3);
            this._texId[3] = 0;
        }
        if (this._texId[3] == 0) {
            GLES20.glGenTextures((int)1, (int[])this._texId, (int)3);
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this._texId[3]);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)n2, (int)n3, (int)0, (int)6409, (int)5121, (Buffer)byteBuffer.position(0));
            this._maskWidth = n2;
            this._maskHeight = n3;
            this._maskBuf = byteBuffer;
        } else if (byteBuffer != this._maskBuf) {
            GLES20.glBindTexture((int)3553, (int)this._texId[3]);
            GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)n2, (int)n3, (int)6409, (int)5121, (Buffer)byteBuffer.position(0));
            this._maskBuf = byteBuffer;
        }
        return true;
    }

    @Override
    float[] manual_ptr(String string) {
        return this._off;
    }
}

