/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import com.justalk.cloud.zmf.EffectFx;
import com.justalk.cloud.zmf.EffectParam;
import com.justalk.cloud.zmf.GLView;
import com.justalk.cloud.zmf.ZmfVideo;

class Silhouette
extends EffectFx {
    float[] _off = new float[3];

    Silhouette() {
    }

    @Override
    boolean compile(GLView.Layer layer) {
        String string = "precision mediump float;\nuniform sampler2D _tex;\nvarying vec2 vTextureCoord;\nuniform vec3 off;\nfloat grey(vec4 c) {\n return dot(c.rgb, vec3(0.299, 0.587, 0.114));\n}\nvoid main(){\n  float p00,p01,p02,p10,p12,p20,p21,p22,gx,gy,edgeSqr;\n  p00 = grey(texture2D( _tex, vTextureCoord + vec2(-off.x, -off.y)));\n  p01 = grey(texture2D( _tex, vTextureCoord + vec2( 0.0,   -off.y)));\n  p02 = grey(texture2D( _tex, vTextureCoord + vec2( off.x, -off.y)));\n  p10 = grey(texture2D( _tex, vTextureCoord + vec2(-off.x, 0.0)));\n  p12 = grey(texture2D( _tex, vTextureCoord + vec2( off.x, 0.0)));\n  p20 = grey(texture2D( _tex, vTextureCoord + vec2(-off.x, off.y)));\n  p21 = grey(texture2D( _tex, vTextureCoord + vec2( 0.0,   off.y)));\n  p22 = grey(texture2D( _tex, vTextureCoord + vec2( off.x, off.y)));\n  gx = (p00 + 2.0*p10 + p20) - (p02 + 2.0*p12 + p22);\n  gy = (p00 + 2.0*p01 + p02) - (p20 + 2.0*p21 + p22);\n  edgeSqr = gx*gx + gy*gy;\n  if(edgeSqr > off.z)\n      gl_FragColor.rgb = vec3(0.0,0.0,0.0);\n  else\n      gl_FragColor = texture2D( _tex, vTextureCoord);\n}\n";
        boolean bl = this.load("attribute vec4 aPosition;\nuniform mat4 _mvp;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = _mvp*aPosition;\n  vTextureCoord = gl_Position.xy*0.5+0.5;\n}\n", string);
        if (!bl) {
            ZmfVideo.logError("can't load Silhouette shader");
        }
        this._off[0] = 2.0f / (float)layer.texWidth;
        this._off[1] = 2.0f / (float)layer.texHeight;
        this._off[2] = 0.5f;
        return bl;
    }

    @Override
    boolean upload_param(int n, GLView.Layer layer) {
        EffectParam effectParam = layer.effect_param;
        for (int i = 0; i < effectParam.argc; ++i) {
            if (effectParam.name[i].equals("hoffset")) {
                this._off[0] = effectParam.value[i] / (float)layer.texWidth;
                continue;
            }
            if (effectParam.name[i].equals("voffset")) {
                this._off[1] = effectParam.value[i] / (float)layer.texHeight;
                continue;
            }
            if (!effectParam.name[i].equals("threshold")) continue;
            this._off[2] = (int)effectParam.value[i];
        }
        return true;
    }

    @Override
    float[] manual_ptr(String string) {
        return this._off;
    }
}

