/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.justalk.cloud.zmf.AudioNative;
import com.justalk.cloud.zmf.AudioOpenSLES;
import com.justalk.cloud.zmf.AudioStd;
import com.justalk.cloud.zmf.Zmf;

abstract class Audio {
    static final int[] _spkStream = new int[]{0, 1, 2, 3, 4, 5, 8};
    static final String[] _spkName = new String[]{"STREAM_VOICE_CALL", "STREAM_SYSTEM", "STREAM_RING", "STREAM_MUSIC", "STREAM_ALARM", "STREAM_NOTIFICATION", "STREAM_DTMF"};
    @SuppressLint(value={"InlinedApi"})
    static final int[] _micSource = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    static final String[] _micName = new String[]{"DEFAULT", "MIC", "VOICE_UPLINK", "VOICE_DOWNLINK", "VOICE_CALL", "CAMCORDER", "VOICE_RECOGNITION", "VOICE_COMMUNICATION"};

    Audio() {
    }

    int outputGetCount() {
        return _spkName.length;
    }

    int outputGetName(int n, String[] stringArray) {
        stringArray[1] = stringArray[0] = _spkName[n];
        return 0;
    }

    int outputGetStreamType(String string) {
        for (int i = 0; i < _spkName.length; ++i) {
            if (!_spkName[i].equals(string)) continue;
            return _spkStream[i];
        }
        return -1;
    }

    int inputGetCount() {
        return _micName.length;
    }

    int inputGetName(int n, String[] stringArray) {
        stringArray[1] = stringArray[0] = _micName[n];
        return 0;
    }

    int inputGetAudioSource(String string) {
        for (int i = 0; i < _micName.length; ++i) {
            if (!_micName[i].equals(string)) continue;
            return _micSource[i];
        }
        return -1;
    }

    abstract int outputStart(String var1, int var2, int var3);

    abstract int outputStop(String var1);

    abstract int outputStopAll();

    abstract int inputStart(String var1, int var2, int var3, int var4, int var5);

    abstract int inputStop(String var1);

    abstract int inputStopAll();

    static Audio create(Context context) {
        String string = Zmf.zmfTraits();
        if (string.contains("AudioNative |")) {
            try {
                if (AudioNative.nvInit(context.getApplicationInfo().nativeLibraryDir, Build.VERSION.SDK_INT) == 0) {
                    return new AudioNative();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string.contains("AudioOpenSLES |")) {
            try {
                PackageManager packageManager;
                boolean bl;
                if (Build.VERSION.SDK_INT >= 9 && (bl = (packageManager = context.getPackageManager()).hasSystemFeature("android.hardware.audio.low_latency")) && AudioOpenSLES.slInit(context.getApplicationInfo().nativeLibraryDir, Build.VERSION.SDK_INT) == 0) {
                    return new AudioOpenSLES(context);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new AudioStd(context);
    }
}

