package com.juphoon.cloud;

import com.justalk.cloud.lemon.Mtc;
import com.justalk.cloud.lemon.MtcGroup;

import org.json.JSONException;
import org.json.JSONObject;

class MtcWrapOperation {

    static final int OPERATION_TYPE_GROUP_INFO = 0;

    JCParam.GroupFetch groupFetchParms;
    int type;
    int cookie;
    String info;
    boolean finish;
    JCNotify notify;

    MtcWrapOperation() {
    }

    boolean deal(int cookie, String name, String info) {
        if (this.cookie != cookie) {
            return false;
        }
        if (this.type == OPERATION_TYPE_GROUP_INFO) {
            finish = dealGroupInfo(name, info);
            return true;
        }
        return false;
    }

    private boolean dealGroupInfo(String name, String info) {
        if (MtcGroup.MtcGroupRefreshOkNotification.equals(name)) {
            if (Mtc.ZOK != MtcGroup.Mtc_GroupGetProperties(cookie, groupFetchParms.groupId)) {
                notifyRefreshFail(MtcGroup.EN_MTC_GROUP_REASON_SERVER);
                return true;
            } else {
                try {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put(MtcGroup.MtcGroupRefreshOkNotification, info);
                    this.info = jsonObject.toString();
                } catch (JSONException e) {
                    e.printStackTrace();
                    notifyRefreshFail(MtcGroup.EN_MTC_GROUP_REASON_SERVER);
                    return true;
                }
                return false;
            }
        } else if (MtcGroup.MtcGroupRefreshDidFailNotification.equals(name)) {
            notify = JCNotify.create(name, cookie, info);
        } else if (MtcGroup.MtcGroupGetPropertiesOkNotification.equals(name)) {
            try {
                JSONObject infoJSON = new JSONObject(this.info);
                JSONObject result = new JSONObject(infoJSON.optString(MtcGroup.MtcGroupRefreshOkNotification));
                JSONObject propJSON = new JSONObject(info);
                result.put(MtcGroup.MtcGroupDisplayNameKey, propJSON.optJSONObject(MtcGroup.MtcGroupPropertiesKey).optString(MtcGroup.MtcGroupPropNameKey));
                notify = JCNotify.create(MtcGroup.MtcGroupRefreshOkNotification, cookie, result.toString());
            } catch (JSONException e) {
                e.printStackTrace();
                notifyRefreshFail(MtcGroup.EN_MTC_GROUP_REASON_SERVER);
                return true;
            }
        } else if (MtcGroup.MtcGroupGetPropertiesDidFailNotification.equals(name)) {
            notify = JCNotify.create(MtcGroup.MtcGroupRefreshDidFailNotification, cookie, info);
        }
        return true;
    }

    private void notifyRefreshFail(int reason) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put(MtcGroup.MtcGroupRidTypeKey, MtcGroup.EN_MTC_GROUP_RESOURCE_ID_GROUP);
            jsonObj.put(MtcGroup.MtcGroupRidKey, groupFetchParms.groupId);
            jsonObj.put(MtcGroup.MtcGroupReasonCodeKey, reason);
            jsonObj.put(MtcGroup.MtcGroupReasonDetailKey, "");
        } catch (JSONException e) {
            e.printStackTrace();
        }
        notify = JCNotify.create(MtcGroup.MtcGroupRefreshDidFailNotification, cookie, jsonObj.toString());
    }
}
