package com.juphoon.cloud;

import java.util.Map;

/**
 * 消息通道消息对象类
 *
 * @author juphoon
 */
public class JCMessageChannelItem {

    String messageId;
    String messageType;
    String text;
    String fileUri;
    String thumbPath;
    int fileSize;
    int duration;
    Map<String, String> extraParams;
    String userId;
    String displayName;
    String groupId;
    long time;
    long sentTime;
    @JCMessageChannel.ItemDirection
    int direction;
    @JCMessageChannel.Type
    int type;
    @JCMessageChannel.ItemState
    int state;
    @JCMediaChannel.MediaChannelReason
    int reason;

    /**
     * 获取消息唯一标识
     *
     * @return 消息唯一标识
     */
    public String getMessageId() {
        return messageId;
    }

    /**
     * 获取消息内容类型
     *
     * @return 消息内容类型
     */
    public String getMessageType() {
        return messageType;
    }

    /**
     * 获取消息内容，包括文本和自定义消息体内容
     *
     * @return 消息内容
     */
    public String getText() {
        return text;
    }

    /**
     * 获取文件链接，可以通过 JCStorage 将文件上传至 Juphoon Cloud 平台来获取该地址，也可以从其他文件消息获取改地址
     *
     * @return 文件链接
     */
    public String getFileUri() {
        return fileUri;
    }

    /**
     * 获取缩略图路径，图片，视频消息有效
     *
     * @return 缩略图路径
     */
    public String getThumbPath() {
        return thumbPath;
    }

    /**
     * 获取文件大小
     *
     * @return 文件大小
     */
    public int getFileSize() {
        return fileSize;
    }

    /**
     * 获取文件时长，语音，视频消息有效
     *
     * @return 文件时长
     */
    public int getDuration() {
        return duration;
    }

    /**
     * 获取自定义参数集
     *
     * @return 自定义参数集
     */
    public Map<String, String> getExtraParams() {
        return extraParams;
    }

    /**
     * 获取对端用户标识
     *
     * @return 消息对端用户标识
     */
    public String getUserId() {
        return userId;
    }

    /**
     * @return 消息对端昵称
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * 返回群id
     *
     * @return 群组标识，type 为 Group 时有效
     */
    public String getGroupId() {
        return groupId;
    }

    /**
     * @return 发送或者接收时间，单位毫秒
     */
    public long getTime() {
        return time;
    }

    /**
     * @return 发送成功时间，单位毫秒，如果是收到消息则是服务器记录的该消息发送时间
     */
    public long getSentTime() {
        return sentTime;
    }

    /**
     * @return 消息发送还是接收
     * @see com.juphoon.cloud.JCMessageChannel.ItemDirection
     */
    public
    @JCMessageChannel.ItemDirection
    int getDirection() {
        return direction;
    }

    /**
     * @return 一对一消息还是群组消息，参见 Type
     */
    public
    @JCMessageChannel.Type
    int getType() {
        return type;
    }

    /**
     * @return 消息状态
     * @see com.juphoon.cloud.JCMessageChannel.ItemState
     */
    public
    @JCMessageChannel.ItemState
    int getState() {
        return state;
    }

    /**
     * 消息错误，当消息状态为 STATE_SENDFAIL 是有效
     */
    public
    @JCMessageChannel.MessageChannelReason
    int getReason() {
        return reason;
    }

}
