package com.juphoon.cloud;

/**
 * 用户配置项模块
 *
 * @author juphoon
 */
public abstract class JCConfig {

    static final String TAG = JCConfig.class.getSimpleName();

    private static JCConfig sConfig;

    /**
     * 通话设置类
     */
    public interface Call {
        /**
         * 设置点对点视频通话动态码率
         *
         * @param enable 是否开启点对点视频通话动态码率
         */
        boolean setVideoArs(boolean enable);

        /**
         * 获取点对点视频通话动态码率开启状态
         */
        boolean getVideoArs();

        /**
         * 设置视频流畅模式
         * @param enable 是否开启视频流畅模式
         */
        boolean setVideoSmoothMode(boolean enable);

        /**
         * 获取视频流畅模式开启状态
         */
        boolean getVideoSmoothMode();
    }

    public Call call;

    /**
     * 创建JCCConfig对象
     *
     * @return JCConfig 对象
     */
    public static JCConfig create() {
        if (sConfig != null) {
            return sConfig;
        }
        return new JCConfigImpl();
    }

    /**
     * 销毁JCConfig实例
     */
    public static void destory() {
        sConfig = null;
    }
}
