/*
 * Decompiled with CFR 0.152.
 */
package com.juphoon.cloud;

import java.util.ArrayList;
import java.util.List;

public class JCDoodleAction {
    private String userId;
    private int actionType;
    private int pageId;
    private int paintColor;
    private float paintStrokeWidth;
    private List<List<String>> intervalPointList;
    private String stickerUnicode;
    private String stickerName;
    private float stickerX;
    private float stickerY;
    private float stickerWidth;
    private float stickerHeight;
    private int stickerRotate;
    private String userDefine;

    private JCDoodleAction(Builder builder) {
        this.actionType = builder.actionType;
        this.userId = builder.userId;
        this.pageId = builder.pageId;
        this.paintColor = builder.paintColor;
        this.paintStrokeWidth = builder.paintStrokeWidth;
        this.intervalPointList = builder.intervalPointList;
        this.stickerUnicode = builder.stickerUnicode;
        this.stickerName = builder.stickerName;
        this.stickerX = builder.stickerX;
        this.stickerY = builder.stickerY;
        this.stickerWidth = builder.stickerWidth;
        this.stickerHeight = builder.stickerHeight;
        this.stickerRotate = builder.stickerRotate;
        this.userDefine = builder.userDefine;
    }

    public String getUserId() {
        return this.userId;
    }

    public int getActionType() {
        return this.actionType;
    }

    public int getPageId() {
        return this.pageId;
    }

    public int getPaintColor() {
        return this.paintColor;
    }

    public float getPaintStrokeWidth() {
        return this.paintStrokeWidth;
    }

    public List<List<String>> getIntervalPointList() {
        return this.intervalPointList;
    }

    public String getStickerUnicode() {
        return this.stickerUnicode;
    }

    public String getStickerName() {
        return this.stickerName;
    }

    public float getStickerX() {
        return this.stickerX;
    }

    public float getStickerY() {
        return this.stickerY;
    }

    public float getStickerWidth() {
        return this.stickerWidth;
    }

    public float getStickerHeight() {
        return this.stickerHeight;
    }

    public int getStickerRotate() {
        return this.stickerRotate;
    }

    public String getUserDefine() {
        return this.userDefine;
    }

    public static final class Builder {
        private int actionType;
        private String userId;
        private int pageId = 0;
        private int paintColor = 0;
        private float paintStrokeWidth = 0.0f;
        private List<List<String>> intervalPointList;
        private String stickerUnicode;
        private String stickerName;
        private float stickerX;
        private float stickerY;
        private float stickerWidth;
        private float stickerHeight;
        private int stickerRotate;
        private String userDefine;

        public Builder(int actionType) {
            this.actionType = actionType;
            this.intervalPointList = new ArrayList<List<String>>();
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder pageId(int pageId) {
            this.pageId = pageId;
            return this;
        }

        public Builder paintColor(int paintColor) {
            this.paintColor = paintColor;
            return this;
        }

        public Builder paintStrokeWidth(float paintStrokeWidth) {
            this.paintStrokeWidth = paintStrokeWidth;
            return this;
        }

        public Builder addActionPoint(int interval, float x, float y) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(String.valueOf(interval));
            list.add(String.valueOf(x));
            list.add(String.valueOf(y));
            this.intervalPointList.add(list);
            return this;
        }

        Builder addActionPoint(String interval, String x, String y) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(interval);
            list.add(x);
            list.add(y);
            this.intervalPointList.add(list);
            return this;
        }

        public Builder stickerUnicode(String stickerUnicode) {
            this.stickerUnicode = stickerUnicode;
            return this;
        }

        public Builder stickerName(String stickerName) {
            this.stickerName = stickerName;
            return this;
        }

        public Builder stickerX(float stickerX) {
            this.stickerX = stickerX;
            return this;
        }

        public Builder stickerY(float stickerY) {
            this.stickerY = stickerY;
            return this;
        }

        public Builder stickerWidth(float stickerWidth) {
            this.stickerWidth = stickerWidth;
            return this;
        }

        public Builder stickerHeight(float stickerHeight) {
            this.stickerHeight = stickerHeight;
            return this;
        }

        public Builder stickerRotate(int stickerRotate) {
            this.stickerRotate = stickerRotate;
            return this;
        }

        public Builder userDefine(String userDefine) {
            this.userDefine = userDefine;
            return this;
        }

        public JCDoodleAction build() {
            return new JCDoodleAction(this);
        }
    }
}

