/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.justalk.cloud.zmf.Render;
import com.justalk.cloud.zmf.ZmfVideo;
import java.nio.ByteBuffer;
import org.json.JSONObject;

@SuppressLint(value={"NewApi"})
class ZmfTextureView
extends TextureView
implements ZmfVideo.RenderCallback,
TextureView.SurfaceTextureListener,
Render {
    Surface mSurface;
    int mHandle = -1;
    Bitmap mBitmap;
    int[] mRGBA;
    ByteBuffer mBuffer;
    int mWidth;
    int mHeight;
    int mViewWidth;
    int mViewHeight;
    String mRenderId;
    int mFullMode;
    int actualFullMode;
    float sx_cutoff;
    float sy_cutoff;
    float sxRatio;
    float syRatio;
    int mOrient = -2;
    int mCfgMirror = 3;

    public ZmfTextureView(Context context) {
        super(context);
        this.setSurfaceTextureListener(this);
    }

    public void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.mViewWidth = n;
        this.mViewHeight = n2;
    }

    @Override
    public synchronized boolean onFrame(String string, int n, int n2, int n3, int n4, int n5, ByteBuffer byteBuffer, int n6) {
        float f;
        float f2;
        boolean bl;
        if (!string.equals(this.mRenderId)) {
            return false;
        }
        if (byteBuffer == null || n4 <= 0 || n5 <= 0) {
            ZmfVideo.onRenderRequestRemove((View)this, n, string);
            return true;
        }
        boolean bl2 = bl = n2 == 90 || n2 == 270;
        if (this.mHeight == 0 && this.mWidth == 0) {
            this.mWidth = n4;
            ZmfVideo.onRenderDidReceive((View)this, n, string, bl ? n5 : n4, bl ? n4 : n5);
        }
        if (this.mSurface == null) {
            return true;
        }
        if (this.mBitmap == null || n5 != this.mHeight || n4 != this.mWidth) {
            if (this.mBitmap == null) {
                ZmfVideo.onRenderDidStart((View)this, n, string, bl ? n5 : n4, bl ? n4 : n5);
            } else {
                ZmfVideo.onRenderDidResize((View)this, n, string, bl ? n5 : n4, bl ? n4 : n5);
            }
            this.mWidth = n4;
            this.mHeight = n5;
            this.mBitmap = Bitmap.createBitmap((int)n4, (int)n5, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mBuffer = ByteBuffer.allocateDirect(n4 * n5 * 4);
            if (!this.mBuffer.asIntBuffer().hasArray()) {
                this.mRGBA = new int[n4 * n5];
            }
        }
        ZmfVideo.convertFromI420(this.mBuffer, 15, byteBuffer, n4, n5);
        if (this.mRGBA != null) {
            this.mBuffer.asIntBuffer().get(this.mRGBA);
            this.mBitmap.setPixels(this.mRGBA, 0, this.mWidth, 0, 0, this.mWidth, this.mHeight);
        } else {
            this.mBitmap.setPixels(this.mBuffer.asIntBuffer().array(), 0, this.mWidth, 0, 0, this.mWidth, this.mHeight);
        }
        int n7 = this.mOrient;
        if (n7 < 0) {
            n7 = n == 1 ? (n7 == -2 ? ZmfVideo.sScreenOrient : (360 - ZmfVideo.renderOrientation()) % 360) : (n7 == -2 ? (ZmfVideo.renderOrientation() + ZmfVideo.sScreenOrient) % 360 : 0);
        }
        float f3 = this.mViewWidth;
        float f4 = this.mViewHeight;
        if ((n2 = (n2 + n7) % 360) == 90 || n2 == 270) {
            f2 = f3 / (float)n5;
            f = f4 / (float)n4;
        } else {
            f2 = f3 / (float)n4;
            f = f4 / (float)n5;
        }
        this.actualFullMode = this.mFullMode;
        if (this.actualFullMode == -1) {
            this.actualFullMode = 1;
            if (f2 > f) {
                if ((double)(1.0f - f / f2) < 0.3) {
                    this.actualFullMode = 0;
                }
            } else if ((double)(1.0f - f2 / f) < 0.3) {
                this.actualFullMode = 0;
            }
        }
        if (this.actualFullMode == 1) {
            if (f2 < f) {
                if (ZmfVideo.sScreenOrient == 0 || ZmfVideo.sScreenOrient == 180) {
                    this.sxRatio = f2 / f;
                    this.syRatio = 1.0f;
                } else {
                    this.sxRatio = 1.0f;
                    this.syRatio = f2 / f;
                }
                f = f2;
            } else {
                if (ZmfVideo.sScreenOrient == 0 || ZmfVideo.sScreenOrient == 180) {
                    this.sxRatio = 1.0f;
                    this.syRatio = f / f2;
                } else {
                    this.sxRatio = f / f2;
                    this.syRatio = 1.0f;
                }
                f2 = f;
            }
        } else if (f2 < f) {
            if (ZmfVideo.sScreenOrient == 0 || ZmfVideo.sScreenOrient == 180) {
                this.sx_cutoff = ((float)n4 - f4 / f) / 2.0f;
                this.sy_cutoff = ((float)n5 - f3 / f) / 2.0f;
            } else {
                this.sx_cutoff = ((float)n4 - f3 / f) / 2.0f;
                this.sy_cutoff = ((float)n5 - f4 / f) / 2.0f;
            }
            f2 = f;
        } else {
            if (ZmfVideo.sScreenOrient == 0 || ZmfVideo.sScreenOrient == 180) {
                this.sx_cutoff = ((float)n4 - f4 / f2) / 2.0f;
                this.sy_cutoff = ((float)n5 - f3 / f2) / 2.0f;
            } else {
                this.sx_cutoff = ((float)n4 - f3 / f2) / 2.0f;
                this.sy_cutoff = ((float)n5 - f4 / f2) / 2.0f;
            }
            f = f2;
        }
        int n8 = this.mCfgMirror & 3;
        if (n8 == 3) {
            int n9 = n8 = n == 1 ? n3 : 0;
        }
        if (n8 != 0) {
            if (n2 == 90 || n2 == 270) {
                if (n8 == 1) {
                    f *= -1.0f;
                } else if (n8 == 2) {
                    f2 *= -1.0f;
                }
            } else if (n8 == 1) {
                f2 *= -1.0f;
            } else if (n8 == 2) {
                f *= -1.0f;
            }
        }
        Canvas canvas = Build.VERSION.SDK_INT >= 23 ? this.mSurface.lockHardwareCanvas() : this.mSurface.lockCanvas(null);
        canvas.translate(f3 / 2.0f, f4 / 2.0f);
        canvas.rotate((float)n2);
        canvas.scale(f2, f);
        canvas.translate((float)(-n4 / 2), (float)(-n5 / 2));
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, null);
        this.mSurface.unlockCanvasAndPost(canvas);
        return true;
    }

    public synchronized void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        if (this.mSurface == null) {
            this.mSurface = new Surface(surfaceTexture);
        }
    }

    public synchronized boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        this.mSurface = null;
        return false;
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    @Override
    public boolean has(String string) {
        return string.equals(this.mRenderId);
    }

    @Override
    public boolean isActive() {
        return this.mHandle != -1 || this.mRenderId != null;
    }

    @Override
    public int videoRenderAdd(String string, int n, int n2) {
        this.mRenderId = string;
        this.mFullMode = n2;
        return 0;
    }

    @Override
    public int videoRenderEffect(String string, int n, JSONObject jSONObject, Object[] objectArray) {
        return -1;
    }

    @Override
    public int videoRenderFillMode(String string, int n) {
        if (!string.equals(this.mRenderId)) {
            return -1;
        }
        this.mFullMode = n;
        return 0;
    }

    @Override
    public int videoRenderFreeze(String string, boolean bl) {
        return -1;
    }

    @Override
    public int videoRenderGetLocation(String string, float[] fArray) {
        return -1;
    }

    @Override
    public int videoRenderMatch(String string, int n, JSONObject jSONObject, Object[] objectArray) {
        return -1;
    }

    @Override
    public int videoRenderMirror(String string, int n) {
        if (!string.equals(this.mRenderId)) {
            return -1;
        }
        this.mCfgMirror = n;
        return 0;
    }

    @Override
    public int videoRenderMove(String string, float f, float f2, float f3, float f4) {
        return -1;
    }

    @Override
    public int videoRenderRemove(String string) {
        if (string.equals(this.mRenderId)) {
            this.mRenderId = null;
        }
        return 0;
    }

    @Override
    public int videoRenderRemoveAll() {
        this.mRenderId = null;
        return 0;
    }

    @Override
    public int videoRenderReplace(String string, String string2) {
        if (!string.equals(this.mRenderId)) {
            return -1;
        }
        this.mRenderId = string2;
        return 0;
    }

    @Override
    public int videoRenderRotate(int n) {
        this.mOrient = n;
        return 0;
    }

    @Override
    public int videoRenderStart() {
        if (this.mHandle == -1) {
            this.mHandle = ZmfVideo.renderAddCallback(this);
        }
        this.mWidth = 0;
        this.mHeight = 0;
        this.mBitmap = null;
        return 0;
    }

    @Override
    public int videoRenderStop() {
        if (this.mHandle != -1) {
            ZmfVideo.renderRemoveCallback(this.mHandle);
            this.mHandle = -1;
        }
        return 0;
    }

    @Override
    public int videoRenderActualFillMode(String string) {
        if (this.has(string)) {
            return this.actualFullMode;
        }
        return -1;
    }

    @Override
    public float[] videoRenderRectPara(String string) {
        if (this.has(string)) {
            float[] fArray = new float[]{this.sx_cutoff, this.sy_cutoff, this.sxRatio, this.syRatio};
            return fArray;
        }
        return null;
    }
}

