/*
 * Decompiled with CFR 0.152.
 */
package com.justalk.cloud.zmf;

import android.content.Context;
import android.hardware.Camera;
import android.os.Build;
import android.view.SurfaceHolder;
import com.justalk.cloud.zmf.CamDrv;
import com.justalk.cloud.zmf.CamView;
import com.justalk.cloud.zmf.CaptureInfo;
import com.justalk.cloud.zmf.DeviceFilter;
import com.justalk.cloud.zmf.UVCCamera;
import com.justalk.cloud.zmf.Zmf;
import com.justalk.cloud.zmf.ZmfVideo;
import java.util.List;
import org.json.JSONObject;

abstract class VideoCapture {
    int[][] _param = new int[8][];
    static final int MAX_CAMERA_NUM = 16;
    static SurfaceHolder _previewHolder;

    abstract int start(String var1, int var2, int var3, int var4);

    abstract int rotate(String var1, int var2);

    abstract int effect(int var1, JSONObject var2, Object[] var3);

    abstract int stop(String var1);

    abstract int stopAll();

    int focusAtPoint(String string, float[] fArray, int n, float f, float f2) {
        return -1;
    }

    static VideoCapture create(Context context) {
        String string;
        if (Build.MODEL.equals("MI 3")) {
            DeviceFilter.avoidPreviewSize(176, 144);
            DeviceFilter.avoidPreviewSize(352, 288);
            DeviceFilter.avoidPreviewSize(704, 576);
            DeviceFilter.avoidPreviewSize(720, 576);
        }
        if ((string = Zmf.zmfTraits()).contains("UVCCamera")) {
            try {
                if (UVCCamera.uvcCamInit(context.getApplicationInfo().nativeLibraryDir, Build.VERSION.SDK_INT) == 0) {
                    return new UVCCamera(context);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string.contains("CamDrv |")) {
            try {
                if (CamDrv.camdrvInit(context.getApplicationInfo().nativeLibraryDir, Build.VERSION.SDK_INT) == 0) {
                    return new CamDrv(context);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Build.VERSION.SDK_INT >= 11) {
            return new CamView(context);
        }
        ZmfVideo.logError("can't support capture on this version:" + Build.VERSION.SDK_INT);
        return null;
    }

    private static String CameraId(Camera.CameraInfo cameraInfo, int n) {
        return "Camera@" + n;
    }

    VideoCapture(Context context) {
        try {
            for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
                CaptureInfo captureInfo = DeviceFilter.getCameraInfo(i);
                if (captureInfo.facing == 0) {
                    ZmfVideo.CAPTURE_BACK = VideoCapture.CameraId(captureInfo, i);
                    continue;
                }
                ZmfVideo.CAPTURE_FRONT = VideoCapture.CameraId(captureInfo, i);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ZmfVideo.logError("getNumberOfCameras failed");
        }
    }

    void teminate() {
    }

    int getCount() {
        return Camera.getNumberOfCameras();
    }

    int getIndexById(String string) {
        try {
            for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
                CaptureInfo captureInfo = DeviceFilter.getCameraInfo(i);
                if (!string.equals(VideoCapture.CameraId(captureInfo, i))) continue;
                return i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ZmfVideo.logError("open failed:" + string);
        }
        return -1;
    }

    String getCaptureBack() {
        try {
            for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
                CaptureInfo captureInfo = DeviceFilter.getCameraInfo(i);
                if (captureInfo.facing != 0) continue;
                return VideoCapture.CameraId(captureInfo, i);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ZmfVideo.logError("open back camera failed");
        }
        return null;
    }

    String getCaptureFront() {
        try {
            for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
                CaptureInfo captureInfo = DeviceFilter.getCameraInfo(i);
                if (captureInfo.facing == 0) continue;
                return VideoCapture.CameraId(captureInfo, i);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ZmfVideo.logError("open front camera failed");
        }
        return null;
    }

    int getName(int n, String[] stringArray) {
        try {
            CaptureInfo captureInfo = DeviceFilter.getCameraInfo(n);
            stringArray[0] = VideoCapture.CameraId(captureInfo, n);
            stringArray[1] = captureInfo.facing == 0 ? "Camera " + n + ", Facing back, Orientation " + captureInfo.orientation : "Camera " + n + ", Facing front, Orientation " + captureInfo.orientation;
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ZmfVideo.logError("open failed:" + n);
            stringArray[0] = "";
            stringArray[1] = "";
            return -1;
        }
    }

    int face(String string, int n) {
        int n2 = this.getIndexById(string);
        if (n2 < 0) {
            ZmfVideo.logError("no capture:" + string);
            return -1;
        }
        CaptureInfo captureInfo = DeviceFilter.getCameraInfo(n2);
        captureInfo.override = true;
        if (n == 1) {
            captureInfo.facing = 1;
        } else if (n == 2) {
            captureInfo.facing = 0;
        } else {
            captureInfo.override = false;
        }
        return 0;
    }

    int getOrient(String string, int[] nArray) {
        int n = this.getIndexById(string);
        if (n < 0) {
            return -1;
        }
        try {
            CaptureInfo captureInfo = DeviceFilter.getCameraInfo(n);
            if (captureInfo.facing == 1) {
                nArray[0] = 1;
                nArray[1] = (360 + captureInfo.orientation) % 360;
                nArray[2] = (360 - nArray[1]) % 360;
            } else {
                nArray[0] = 2;
                nArray[1] = (360 + captureInfo.orientation) % 360;
                nArray[2] = nArray[1];
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ZmfVideo.logError("open failed:" + string);
            return -1;
        }
    }

    int[] getCamParam(String string) {
        int n = this.getIndexById(string);
        if (n < 0) {
            ZmfVideo.logError("no capture:" + string);
            return null;
        }
        int[] nArray = this._param[n];
        if (nArray == null) {
            Camera camera;
            try {
                camera = Camera.open((int)n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ZmfVideo.logError("open failed:" + string);
                return null;
            }
            Camera.Parameters parameters = camera.getParameters();
            camera.release();
            List list = parameters.getSupportedPreviewFrameRates();
            List list2 = parameters.getSupportedPreviewSizes();
            int n2 = 1;
            if (list != null) {
                for (Object object : list) {
                    if ((Integer)object <= n2) continue;
                    n2 = (Integer)object;
                }
            }
            if (list2 != null) {
                nArray = new int[list2.size() * 3];
                this._param[n] = nArray;
                int n3 = 0;
                for (Camera.Size size : list2) {
                    nArray[n3++] = size.width;
                    nArray[n3++] = size.height;
                    nArray[n3++] = n2;
                }
            } else {
                nArray = new int[]{352, 288, 1};
                this._param[n] = nArray;
            }
        }
        return nArray;
    }

    static SurfaceHolder setPreviewDisplay(SurfaceHolder surfaceHolder) {
        SurfaceHolder surfaceHolder2 = _previewHolder;
        _previewHolder = surfaceHolder;
        return surfaceHolder2;
    }
}

